/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.IRunnable;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.WindowTools;
import mcjty.lib.gui.events.ChannelEvent;
import mcjty.lib.gui.events.FocusEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.StringRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.simple.SimpleChannel;

public class Window {
    public static final Key<String> PARAM_ID = new Key<String>("id", Type.STRING);
    private AbstractContainerWidget<?> toplevel;
    private final Screen gui;
    private Widget<?> textFocus = null;
    private Widget<?> hover = null;
    private GuiStyle currentStyle;
    private WindowManager windowManager;
    private final Map<String, List<ChannelEvent>> channelEvents = new HashMap<String, List<ChannelEvent>>();
    private final Map<Widget, Function> bindings = new HashMap<Widget, Function>();
    private final Set<Integer> activeFlags = new HashSet<Integer>();
    private List<FocusEvent> focusEvents = null;

    public Screen getGui() {
        return this.gui;
    }

    public Window(Screen gui, AbstractContainerWidget<?> toplevel) {
        this.gui = gui;
        this.toplevel = toplevel;
    }

    public Window(Screen gui, SimpleChannel wrapper, ResourceLocation guiDescription) {
        this.gui = gui;
        int[] dim = new int[]{-1, -1};
        int[] sidesize = new int[]{0, 0};
        this.parseInternal(null, null, wrapper, guiDescription, dim, sidesize);
        if (dim[0] != -1 || dim[1] != -1) {
            if (gui instanceof GuiItemScreen) {
                GuiItemScreen container = (GuiItemScreen)gui;
                container.setWindowDimensions(dim[0], dim[1]);
            }
            int guiLeft = (gui.f_96543_ - dim[0]) / 2;
            int guiTop = (gui.f_96544_ - dim[1]) / 2;
            this.toplevel.bounds(guiLeft - sidesize[0], guiTop - sidesize[1], dim[0] + sidesize[0], dim[1] + sidesize[1]);
        }
    }

    public Window(Screen gui, GenericTileEntity tileEntity, SimpleChannel wrapper, ResourceLocation guiDescription) {
        this.gui = gui;
        int[] dim = new int[]{-1, -1};
        int[] sidesize = new int[]{0, 0};
        this.parseInternal((GenericGuiContainer)gui, tileEntity, wrapper, guiDescription, dim, sidesize);
        if (dim[0] != -1 || dim[1] != -1) {
            if (gui instanceof GenericGuiContainer) {
                GenericGuiContainer container = (GenericGuiContainer)gui;
                container.setWindowDimensions(dim[0], dim[1]);
            }
            int guiLeft = (gui.f_96543_ - dim[0]) / 2;
            int guiTop = (gui.f_96544_ - dim[1]) / 2;
            this.toplevel.bounds(guiLeft - sidesize[0], guiTop - sidesize[1], dim[0] + sidesize[0], dim[1] + sidesize[1]);
        }
    }

    private void parseInternal(@Nullable GenericGuiContainer<?, ?> gui, @Nullable GenericTileEntity tileEntity, SimpleChannel wrapper, ResourceLocation guiDescription, int[] dim, int[] sidesize) {
        try {
            WindowTools.parseAndHandleClient(guiDescription, command -> {
                if ("window".equals(command.getId())) {
                    command.findCommand("size").ifPresent(cmd -> {
                        dim[0] = cmd.getOptionalPar(0, -1);
                        dim[1] = cmd.getOptionalPar(1, -1);
                    });
                    command.findCommand("sidesize").ifPresent(cmd -> {
                        sidesize[0] = cmd.getOptionalPar(0, 0);
                        sidesize[1] = cmd.getOptionalPar(1, 0);
                    });
                    command.commands().filter(cmd -> "event".equals(cmd.getId())).forEach(cmd -> {
                        if (gui != null) {
                            String channel = cmd.getOptionalPar(0, "");
                            String teCommand = cmd.getOptionalPar(1, "");
                            this.event(channel, (source, params) -> gui.sendServerCommandTyped(wrapper, teCommand, params));
                        }
                    });
                    command.commands().filter(cmd -> "cmdevent".equals(cmd.getId())).forEach(cmd -> {
                        String channel = cmd.getOptionalPar(0, "");
                        String modidCmd = cmd.getOptionalPar(1, "");
                        ResourceLocation rl = new ResourceLocation(modidCmd);
                        this.event(channel, (source, params) -> wrapper.sendToServer((Object)new PacketSendServerCommand(rl.m_135827_(), rl.m_135815_(), TypedMap.EMPTY)));
                    });
                    command.findCommand("panel").ifPresent(cmd -> {
                        this.toplevel = new Panel();
                        this.toplevel.readFromGuiCommand((GuiParser.GuiCommand)cmd);
                    });
                    command.commands().filter(cmd -> "bind".equals(cmd.getId())).forEach(cmd -> {
                        if (tileEntity != null) {
                            String component = cmd.getOptionalPar(0, "");
                            String value = cmd.getOptionalPar(1, "");
                            this.bind(wrapper, component, tileEntity, value);
                        }
                    });
                    command.commands().filter(cmd -> "action".equals(cmd.getId())).forEach(cmd -> {
                        if (tileEntity != null) {
                            String component = cmd.getOptionalPar(0, "");
                            String key = cmd.getOptionalPar(1, "");
                            this.action(wrapper, component, tileEntity, key);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.length() > 70) {
                int i = message.lastIndexOf(58);
                message = i == -1 ? message.substring(message.length() - 70) : message.substring(i + 1);
            }
            this.toplevel = ((Panel)((Panel)((Panel)((Panel)Widgets.positional().desiredWidth(400)).desiredHeight(50)).filledBackground(-1)).filledRectThickness(2)).children(new Widget[]{Widgets.label(message).hint(5, 5, 390, 40)});
            dim[0] = 400;
            dim[1] = 50;
            e.printStackTrace();
        }
    }

    public <T extends Widget<T>> T findChild(String name) {
        Widget<?> widget = this.toplevel.findChildRecursive(name);
        if (widget == null) {
            Logging.logError("Could not find widget '" + name + "'!");
        }
        return (T)widget;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public boolean isWidgetOnWindow(Widget<?> w) {
        return this.toplevel.containsWidget(w);
    }

    public Widget<?> getToplevel() {
        return this.toplevel;
    }

    public void setFlag(String flag) {
        if (flag.startsWith("!")) {
            this.activeFlags.remove(StringRegister.STRINGS.get(flag.substring(1)));
        } else {
            this.activeFlags.remove(StringRegister.STRINGS.get("!" + flag));
        }
        this.activeFlags.add(StringRegister.STRINGS.get(flag));
        this.enableDisableWidgets(this.toplevel);
    }

    public void clearFlag(String flag) {
        this.activeFlags.remove(StringRegister.STRINGS.get(flag));
        this.activeFlags.add(StringRegister.STRINGS.get("!" + flag));
        this.enableDisableWidgets(this.toplevel);
    }

    public void setFlag(String flag, boolean v) {
        if (v) {
            this.activeFlags.remove(StringRegister.STRINGS.get("!" + flag));
            this.activeFlags.add(StringRegister.STRINGS.get(flag));
        } else {
            this.activeFlags.remove(StringRegister.STRINGS.get(flag));
            this.activeFlags.add(StringRegister.STRINGS.get("!" + flag));
        }
        this.enableDisableWidgets(this.toplevel);
    }

    private void enableDisableWidgets(Widget<?> widget) {
        Set<Integer> enabledFlags = widget.getEnabledFlags();
        if (!enabledFlags.isEmpty()) {
            boolean enable = this.activeFlags.containsAll(enabledFlags);
            widget.enabled(enable);
        }
        if (widget instanceof AbstractContainerWidget) {
            for (Widget<?> child : ((AbstractContainerWidget)widget).getChildren()) {
                this.enableDisableWidgets(child);
            }
        }
    }

    public Widget<?> getWidgetAtPosition(double x, double y) {
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            return this.toplevel.getWidgetAtPosition(x, y);
        }
        return null;
    }

    public void mouseClicked(double x, double y, int button) {
        if (this.textFocus != null) {
            this.textFocus = null;
            this.fireFocusEvents(null);
        }
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            this.toplevel.setWindow(this);
            this.toplevel.mouseClick(x, y, button);
        }
    }

    public void mouseDragged(double x, double y, int button) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseMove(x, y);
    }

    public void mouseScrolled(double x, double y, double amount) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseScrolled(x, y, amount);
    }

    public void mouseReleased(double x, double y, int button) {
        this.toplevel.setWindow(this);
        this.toplevel.mouseRelease(x, y, button);
    }

    public void setTextFocus(Widget<?> focus) {
        if (this.windowManager != null) {
            this.windowManager.clearFocus();
        }
        this.setFocus(focus);
    }

    void setFocus(Widget<?> focus) {
        if (this.textFocus != focus) {
            this.textFocus = focus;
            this.fireFocusEvents(focus);
        }
    }

    public Widget<?> getTextFocus() {
        return this.textFocus;
    }

    public boolean charTyped(char codePoint) {
        if (this.textFocus != null) {
            return this.textFocus.charTyped(codePoint);
        }
        return false;
    }

    public boolean keyTyped(int keyCode, int scanCode) {
        if (keyCode == 301) {
            GuiParser.GuiCommand windowCmd = this.createWindowCommand();
            GuiParser.GuiCommand command = this.toplevel.createGuiCommand();
            this.toplevel.fillGuiCommand(command);
            windowCmd.command(command);
            try (PrintWriter writer = new PrintWriter(new File("output.gui"));){
                windowCmd.write(writer, 0);
                writer.flush();
            }
            catch (FileNotFoundException e) {
                Logging.logError("Problem writing output.gui!", e);
            }
        }
        if (this.textFocus != null) {
            return this.textFocus.keyTyped(keyCode, scanCode);
        }
        return false;
    }

    private GuiParser.GuiCommand createWindowCommand() {
        GuiParser.GuiCommand windowCmd = new GuiParser.GuiCommand("window");
        windowCmd.command(new GuiParser.GuiCommand("size").parameter((int)this.toplevel.getBounds().getWidth()).parameter((int)this.toplevel.getBounds().getHeight()));
        return windowCmd;
    }

    public <T extends GenericTileEntity> void syncBindings(T te) {
        this.bindings.entrySet().forEach(entry -> ((Widget)entry.getKey()).setGenericValue(((Function)entry.getValue()).apply(te)));
    }

    public void draw(GuiGraphics graphics) {
        int dwheel;
        int x = this.getRelativeX();
        int y = this.getRelativeY();
        if (this.hover != null) {
            this.hover.hovering(false);
        }
        this.hover = this.toplevel.getWidgetAtPosition(x, y);
        if (this.hover != null) {
            this.hover.hovering(true);
        }
        if (this.windowManager == null) {
            dwheel = 0;
        } else {
            dwheel = this.windowManager.getMouseWheel();
            if (dwheel == -1) {
                dwheel = 0;
            }
        }
        if (dwheel != 0) {
            this.toplevel.setWindow(this);
            this.toplevel.mouseScrolled(x, y, dwheel);
        }
        this.currentStyle = McJtyLib.getPreferencesProperties((Player)this.gui.getMinecraft().f_91074_).map(PreferencesProperties::getStyle).orElse(GuiStyle.STYLE_FLAT_GRADIENT);
        this.toplevel.setWindow(this);
        this.toplevel.draw(this.gui, graphics, 0, 0);
        this.toplevel.drawPhase2(this.gui, graphics, 0, 0);
    }

    public GuiStyle getCurrentStyle() {
        return this.currentStyle;
    }

    @Nullable
    public List<String> getTooltips() {
        Widget<?> w;
        List<String> tooltips;
        int y;
        int x = this.getRelativeX();
        if (this.toplevel.in(x, y = this.getRelativeY()) && this.toplevel.isVisible() && (tooltips = (w = this.toplevel.getWidgetAtPosition(x, y)).getTooltips()) != null) {
            return tooltips;
        }
        return null;
    }

    @Nullable
    public List<ItemStack> getTooltipItems() {
        int y;
        int x = this.getRelativeX();
        if (this.toplevel.in(x, y = this.getRelativeY()) && this.toplevel.isVisible()) {
            Widget<?> w = this.toplevel.getWidgetAtPosition(x, y);
            return w.getTooltipItems();
        }
        return null;
    }

    private int getRelativeX() {
        int windowWidth = this.gui.getMinecraft().m_91268_().m_85443_();
        if (windowWidth == 0) {
            return 0;
        }
        return (int)this.gui.getMinecraft().f_91067_.m_91589_() * this.gui.f_96543_ / windowWidth;
    }

    private int getRelativeY() {
        int windowHeight = this.gui.getMinecraft().m_91268_().m_85444_();
        if (windowHeight == 0) {
            return 0;
        }
        return (int)this.gui.getMinecraft().f_91067_.m_91594_() * this.gui.f_96544_ / windowHeight;
    }

    public Window addFocusEvent(FocusEvent event) {
        if (this.focusEvents == null) {
            this.focusEvents = new ArrayList<FocusEvent>();
        }
        this.focusEvents.add(event);
        return this;
    }

    private void fireFocusEvents(Widget<?> widget) {
        if (this.focusEvents != null) {
            for (FocusEvent event : this.focusEvents) {
                event.focus(widget);
            }
        }
    }

    public Window event(String channel, ChannelEvent event) {
        if (!this.channelEvents.containsKey(channel)) {
            this.channelEvents.put(channel, new ArrayList());
        }
        this.channelEvents.get(channel).add(event);
        return this;
    }

    public <T extends GenericTileEntity> Window action(SimpleChannel network, String componentName, T te, Command<?> command) {
        return this.action(network, componentName, te, command.name());
    }

    public <T extends GenericTileEntity> Window action(SimpleChannel network, String componentName, T te, String keyName) {
        IRunnable<?> serverCommand = te.findServerCommand(keyName);
        if (serverCommand != null) {
            this.initializeAction(network, componentName, keyName, te);
            return this;
        }
        Logging.message((Player)Minecraft.m_91087_().f_91074_, "Could not find action '" + keyName + "' in supplied TE!");
        return this;
    }

    private <T extends GenericTileEntity> void initializeAction(SimpleChannel network, String componentName, String command, T te) {
        this.event(componentName, (source, params) -> network.sendToServer((Object)new PacketServerCommandTyped(te.m_58899_(), te.getDimension(), command, params)));
    }

    public void sendServerCommand(SimpleChannel network, Command<?> action, @Nonnull TypedMap params) {
        GenericGuiContainer guiContainer = (GenericGuiContainer)this.gui;
        guiContainer.sendServerCommandTyped(network, action, params);
    }

    public <T extends GenericTileEntity> Window bind(SimpleChannel network, String componentName, T te, String keyName) {
        Map<String, ValueHolder<?, ?>> valueMap = te.getValueMap();
        if (valueMap.containsKey(keyName)) {
            ValueHolder<?, ?> value = valueMap.get(keyName);
            this.initializeBinding(network, te.getDimension(), componentName, te, value);
            return this;
        }
        Logging.message((Player)Minecraft.m_91087_().f_91074_, "Could not find value '" + keyName + "' in supplied TE!");
        return this;
    }

    private <T extends GenericTileEntity, V> void initializeBinding(SimpleChannel network, @Nonnull ResourceKey<Level> dimensionType, String componentName, T te, ValueHolder value) {
        Object v = value.getter().apply(te);
        Object component = this.findChild(componentName);
        if (component == null) {
            Logging.message((Player)Minecraft.m_91087_().f_91074_, "Could not find component '" + componentName + "'!");
            return;
        }
        component.setGenericValue(v);
        this.bindings.put((Widget)component, value.getter());
        this.event(componentName, (source, params) -> {
            Type type = value.key().type();
            Object converted = type.convert(component.getGenericValue(type));
            value.setter().accept(te, converted);
            GenericGuiContainer guiContainer = (GenericGuiContainer)this.gui;
            guiContainer.sendServerCommandTyped(network, dimensionType, GenericTileEntity.COMMAND_SYNC_BINDING.name(), TypedMap.builder().put(value.key(), converted).build());
        });
    }

    public void fireChannelEvents(String channel, Widget<?> widget, @Nonnull TypedMap params) {
        if (this.channelEvents.containsKey(channel)) {
            for (ChannelEvent event : this.channelEvents.get(channel)) {
                event.fire(widget, params);
            }
        }
    }
}

