/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;

public class ContractMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<ContractMahoujinTileEntity> {
    private int tickCounter = 0;

    public ContractMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.contract.get(), p, bs);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, ContractMahoujinTileEntity contractMahoujinTileEntity) {
        if (!level.f_46443_) {
            MahouSavedData save = new MahouSavedData(level);
            if (this.tickCounter == MTConfig.CONTRACT_BLOCK_CYCLE) {
                Player casterPresent;
                ArrayList<Player> targets = this.getTargets();
                if (targets != null && !targets.isEmpty() && (casterPresent = this.entityReadyToContract()) != null) {
                    for (Player entityIn : targets) {
                        if (save.doesContractExist(casterPresent.m_20148_(), entityIn.m_20148_()) || PlayerManaManager.drainMana(casterPresent, MTConfig.CONTRACT_MANA_COST, false, false) != MTConfig.CONTRACT_MANA_COST || !save.addContractIfNotExists(casterPresent.m_20148_(), entityIn.m_20148_())) continue;
                        entityIn.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "A contract has been formed with " + casterPresent.m_5446_().getString())), true);
                        casterPresent.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "A contract has been formed with " + entityIn.m_5446_().getString())), true);
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public ArrayList<Player> getTargets() {
        int radius = MTConfig.CONTRACT_RADIUS;
        Stream blocks = BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-radius, -radius, -radius), (BlockPos)this.f_58858_.m_7918_(radius, radius, radius));
        ArrayList<Player> ret = new ArrayList<Player>();
        blocks.forEach(tmp -> {
            ContractMahoujinTileEntity mte;
            Player player;
            BlockEntity te = this.f_58857_.m_7702_(tmp);
            if (te instanceof ContractMahoujinTileEntity && !this.f_58858_.equals(tmp) && (player = (mte = (ContractMahoujinTileEntity)te).entityReadyToContract()) != null && player.m_6084_()) {
                ret.add(player);
            }
        });
        return ret;
    }

    public Player entityReadyToContract() {
        List lst = this.f_58857_.m_45976_(Player.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
        if (lst.isEmpty() || !lst.contains(this.getCaster())) {
            return null;
        }
        return this.getCaster();
    }

    public static boolean isImmuneToSpell(Level world, UUID caster, Entity e) {
        ServerPlayer player;
        MinecraftServer server;
        UUID ownerId;
        MahouSavedData save = new MahouSavedData(world);
        if (e instanceof ArmorStand) {
            return true;
        }
        if (e instanceof TamableAnimal && caster != null && (ownerId = ((TamableAnimal)e).m_21805_()) != null && (ownerId.equals(caster) || save.doesContractExist(caster, ownerId))) {
            return true;
        }
        if (e instanceof MentalDisplacementEntity && caster != null && (ownerId = ((MentalDisplacementEntity)e).getOwnerId()) != null && (ownerId.equals(caster) || save.doesContractExist(caster, ownerId))) {
            return true;
        }
        if (e instanceof Player && caster != null) {
            if (e.m_20148_().equals(caster)) {
                return true;
            }
            if (save.doesContractExist(caster, e.m_20148_())) {
                return true;
            }
            if (((Player)e).m_7500_() || e.m_5833_()) {
                return true;
            }
        }
        return caster != null && e instanceof LivingEntity && (server = world.m_7654_()) != null && (player = server.m_6846_().m_11259_(caster)) != null && GeasEffect.hasGeas((Player)player, (LivingEntity)e);
    }

    public static void breakContract(LivingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!player.m_9236_().f_46443_) {
                MahouSavedData save = new MahouSavedData(player.m_9236_());
                if (event.getSource() != null && event.getSource().m_7639_() != null && event.getSource().m_7639_().m_20148_() != null && save.doesContractExist(player.m_20148_(), event.getSource().m_7639_().m_20148_())) {
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "A contract has broken.")), true);
                    if (event.getSource().m_7639_() instanceof Player) {
                        ((Player)event.getSource().m_7639_()).m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "A contract has broken.")), true);
                    }
                    save.removeContract(player.m_20148_(), event.getSource().m_7639_().m_20148_());
                }
            }
        }
    }
}

