/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.Utils;

public class SpellScroll
extends ItemBase {
    public SpellScroll(String name) {
        super("scroll_" + name);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            IScrollMahou mahou = Utils.getScrollMahou(stack);
            return (CompoundTag)ScrollMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IScrollMahou scrollMahou;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Item item = stack.m_41720_();
        if (item instanceof SpellScroll && Utils.getScrollMahou(stack) != null && (scrollMahou = Utils.getScrollMahou(stack)) != null) {
            String name = scrollMahou.getCasterName();
            if (name != null && !name.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)("Bound to " + name)));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Bound to: ???"));
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        if (nbtt != null) {
            IScrollMahou scrollMahou = Utils.getScrollMahou(stack);
            ScrollMahou serverScrollMahou = new ScrollMahou();
            ScrollMahouStorage.readNBT(serverScrollMahou, (Tag)nbtt);
            if (scrollMahou != null) {
                scrollMahou.setCasterUUID(serverScrollMahou.getCasterUUID());
                scrollMahou.setCasterName(serverScrollMahou.getCasterName());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ScrollMahouProvider();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        playerIn.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        this.useAction(stack, worldIn, entityLiving, true);
    }

    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.f_46443_) {
            int cost = this.getInitialManaCost();
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof Player && Utils.getPlayerMahou((Player)entityLiving) != null) {
                Player user = (Player)entityLiving;
                if (scrollMahou != null && (user.m_20148_().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.m_7500_()) && PlayerManaManager.drainMana(user, cost, false, false) == cost) {
                    if (this.shouldConsume(user, scrollMahou, consume)) {
                        stack.m_41774_(1);
                    }
                    stack.m_41751_((CompoundTag)ScrollMahouStorage.writeNBT(scrollMahou));
                }
            }
        }
    }

    public boolean shouldConsume(Player user, IScrollMahou scrollMahou, boolean consume) {
        return this.doSpell(user, scrollMahou) && (!user.m_7500_() || MTConfig.CREATIVE_MODE_SPELLS) && consume;
    }

    public IScrollMahou getCapability(ItemStack stack) {
        if (stack != null && stack.m_41720_() instanceof SpellScroll) {
            return Utils.getScrollMahou(stack);
        }
        return null;
    }

    public int getInitialManaCost() {
        return 0;
    }

    public boolean doSpell(Player user, IScrollMahou mahou) {
        return false;
    }
}

