/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class BeamProjectileEntity
extends Entity {
    public static final String entityName = "beam_projectile_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    private static final String TAG_RADIUS = "MAHOUTSUKAI_RADIUS";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A2 = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.m_135353_(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public BeamProjectileEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.BEAM_PROJECTILE.get(), worldIn);
        this.f_19811_ = true;
    }

    public BeamProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BeamProjectileEntity(Level world) {
        super((EntityType)ModEntities.BEAM_PROJECTILE.get(), world);
        this.f_19811_ = true;
    }

    public BeamProjectileEntity(Level world, UUID caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2, float radius, float length) {
        this(world);
        this.setCasterUUID(caster);
        this.setColor(r, g, b, a, r2, g2, b2, a2);
        this.setRadius(radius);
        this.setLength(length);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_R2, (Object)Float.valueOf(r2));
        this.f_19804_.m_135381_(COLOR_G2, (Object)Float.valueOf(g2));
        this.f_19804_.m_135381_(COLOR_B2, (Object)Float.valueOf(b2));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
        this.f_19804_.m_135381_(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_R2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A2)).floatValue()};
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(FIRED, (Object)false);
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LENGTH, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setFired(compound.m_128471_(TAG_FIRED));
        if (compound.m_128403_(TAG_CASTER)) {
            this.setCasterUUID(compound.m_128342_(TAG_CASTER));
        }
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A), compound.m_128457_(TAG_COLOR_R2), compound.m_128457_(TAG_COLOR_G2), compound.m_128457_(TAG_COLOR_B2), compound.m_128457_(TAG_COLOR_A2));
        this.setLength(compound.m_128457_(TAG_LENGTH));
        this.setRadius(compound.m_128457_(TAG_RADIUS));
        this.setRotationYaw(compound.m_128457_(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.m_128457_(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.m_128457_(TAG_ROTATION_PITCH));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128379_(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.m_128362_(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_COLOR_R2, colors[4]);
        compound.m_128350_(TAG_COLOR_G2, colors[5]);
        compound.m_128350_(TAG_COLOR_B2, colors[6]);
        compound.m_128350_(TAG_COLOR_A2, colors[7]);
        compound.m_128350_(TAG_LENGTH, this.getLength());
        compound.m_128350_(TAG_RADIUS, this.getRadius());
        compound.m_128350_(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.m_128350_(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.m_128350_(TAG_ROTATION_PITCH, this.getRotationPitch());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.timeCreated == -1L) {
            this.timeCreated = this.m_9236_().m_46467_();
        }
        this.setLife(this.getLife() + 1);
        if (!(this.m_9236_().f_46443_ || this.ticksSinceFired <= 400 && this.m_9236_().m_46467_() - this.timeCreated <= 800L)) {
            this.m_146870_();
        }
        ++this.ticksSinceFired;
        if (!this.m_9236_().f_46443_) {
            this.setLength((float)Math.min(3.0, (double)this.getLength() + this.m_20184_().m_82553_() / 5.0));
            this.checkHit();
        }
        this.m_6021_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
    }

    public void checkHit() {
        EntityHitResult entityraytraceresult;
        Vec3 vec3d = this.m_20184_();
        Vec3 vec3d2 = this.m_20182_();
        Vec3 vec3d3 = vec3d2.m_82549_(vec3d);
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(vec3d2, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vec3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY && raytraceresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
            Entity entity1 = this.getShooter();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.m_9236_(), this.getCasterUUID(), entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
            this.onHit((HitResult)raytraceresult);
        }
        raytraceresult = null;
    }

    public void onHit(HitResult result) {
        Vec3 target = result.m_82450_();
        double x = target.f_82479_;
        double y = target.f_82480_;
        double z = target.f_82481_;
        Player caster = this.m_9236_().m_46003_(this.getCasterUUID());
        if (caster != null) {
            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou(caster)));
            explosion.explosionA(this.m_9236_(), caster);
            for (Player entityplayer : this.m_9236_().m_6907_()) {
                if (!(entityplayer.m_20275_(x, y, z) < 16384.0)) continue;
                Vec3 vec = null;
                if (explosion.knockback.containsKey(caster)) {
                    vec = explosion.knockback.get(caster);
                }
                if (vec == null) {
                    PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                    continue;
                }
                PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_));
            }
        }
        this.m_146870_();
    }

    public Vec3 setLookPos(boolean client, Entity caster, boolean add) {
        Vec3 look = caster.m_20154_();
        Vec3 oldlook = look.m_82541_();
        look = oldlook.m_82490_((double)1.1f);
        Vec3 start = look.m_82549_(caster.m_20182_());
        this.f_19857_ = caster.f_19857_;
        this.f_19858_ = caster.f_19858_;
        if (add) {
            this.f_19858_ = 90.0f - this.f_19858_;
        }
        this.f_19859_ = this.f_19857_;
        this.f_19860_ = this.f_19858_;
        if (!client && add) {
            this.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        }
        return start;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.m_9236_() instanceof ServerLevel ? ((ServerLevel)this.m_9236_()).m_8791_(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_213871_1_ -> !p_213871_1_.m_5833_() && p_213871_1_.m_6084_() && p_213871_1_.m_6087_() && !(p_213871_1_ instanceof BeamProjectileEntity) && (!p_213871_1_.m_20148_().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }

    public void setFired(boolean f) {
        this.f_19804_.m_135381_(FIRED, (Object)f);
    }

    public float getLength() {
        return ((Float)this.f_19804_.m_135370_(LENGTH)).floatValue();
    }

    public void setLength(float f) {
        this.f_19804_.m_135381_(LENGTH, (Object)Float.valueOf(f));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float f) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(f));
    }

    public float getRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.f_19804_.m_135381_(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.f_19804_.m_135381_(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.f_19804_.m_135381_(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

