/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells.boundary;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.TangibleBoundaryMahoujinTileEntity;

public class InvisibleBarrierBlock
extends BlockTileEntity<InvisibleBarrierBlockTileEntity> {
    AABB collisionCaster;
    VoxelShape castershape;
    AABB collisionElse;
    VoxelShape elseshape;

    public InvisibleBarrierBlock() {
        BlockBehaviour.Properties.m_284310_();
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50375_).m_60955_().m_60913_(5.0f, 10.0f), "invisible_barrier_block");
        this.collisionCaster = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.castershape = Shapes.m_83064_((AABB)this.collisionCaster);
        this.collisionElse = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.elseshape = Shapes.m_83064_((AABB)this.collisionElse);
    }

    public List<ItemStack> m_49635_(BlockState p_287732_, LootParams.Builder p_287596_) {
        return new ArrayList<ItemStack>();
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult result, Projectile entityIn) {
        this.m_7892_(state, worldIn, result.m_82425_(), (Entity)entityIn);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_ && entityIn != null && entityIn.m_6084_()) {
            UUID entUUID = entityIn.m_20148_();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)worldIn.m_7702_(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID)) {
                    return;
                }
                Direction side = Direction.NORTH;
                if (entityIn.m_20185_() < (double)pos.m_123341_()) {
                    side = Direction.WEST;
                } else if (entityIn.m_20185_() > (double)(pos.m_123341_() + 1)) {
                    side = Direction.EAST;
                } else if (entityIn.m_20186_() < (double)pos.m_123342_()) {
                    side = Direction.DOWN;
                } else if (entityIn.m_20186_() > (double)(pos.m_123342_() + 1)) {
                    side = Direction.UP;
                } else if (entityIn.m_20189_() < (double)pos.m_123343_()) {
                    side = Direction.NORTH;
                } else if (entityIn.m_20189_() > (double)(pos.m_123343_() + 1)) {
                    side = Direction.SOUTH;
                }
                te.setTimeOfCollision(worldIn.m_46467_(), side);
            }
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Entity e;
        if (context instanceof EntityCollisionContext && (e = ((EntityCollisionContext)context).m_193113_()) != null && e.m_6084_()) {
            UUID entUUID = e.m_20148_();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)reader.m_7702_(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (!(te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID))) {
                    return this.elseshape;
                }
            }
            if (e.m_6047_()) {
                return this.elseshape;
            }
        }
        return this.castershape;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity te;
        if (world.m_46467_() % 100L == 0L && (te = world.m_7702_(pos)) instanceof InvisibleBarrierBlockTileEntity) {
            try {
                BlockEntity tte = world.m_7702_(((InvisibleBarrierBlockTileEntity)te).boundaryCircle);
                if (tte instanceof TangibleBoundaryMahoujinTileEntity) {
                    int radius;
                    TangibleBoundaryMahoujinTileEntity mte = (TangibleBoundaryMahoujinTileEntity)tte;
                    if (!mte.shouldIPerformBarrier()) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                    if ((radius = mte.getBarrierRadius()) != Math.abs(pos.m_123341_() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.m_123341_()) || radius != Math.abs(pos.m_123342_() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.m_123342_()) || radius != Math.abs(pos.m_123343_() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.m_123343_())) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                } else {
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            }
            catch (Exception e) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Override
    public Class<InvisibleBarrierBlockTileEntity> getTileEntityClass() {
        return InvisibleBarrierBlockTileEntity.class;
    }

    @Nullable
    public InvisibleBarrierBlockTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InvisibleBarrierBlockTileEntity(blockPos, blockState);
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return this.castershape;
    }

    public boolean m_49967_() {
        return true;
    }
}

