/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class PossessEntityPacket {
    int entityId = 0;
    int chunkx = 0;
    int chunkz = 0;

    public PossessEntityPacket() {
    }

    public PossessEntityPacket(int x, int z, int entity) {
        this.entityId = entity;
        this.chunkx = x;
        this.chunkz = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.chunkx = buf.readInt();
        this.chunkz = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.chunkx);
        buf.writeInt(this.chunkz);
    }

    public static void encode(PossessEntityPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static PossessEntityPacket decode(FriendlyByteBuf buf) {
        PossessEntityPacket msg = new PossessEntityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(PossessEntityPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.possess(message);
        context.get().setPacketHandled(true);
    }
}

