/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.WallStickPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityJumpPacket {
    double lookX;
    double lookY;
    double lookZ;
    long held;

    public AuthorityJumpPacket() {
    }

    public AuthorityJumpPacket(double x, double y, double z, long h) {
        this.lookX = x;
        this.lookY = y;
        this.lookZ = z;
        this.held = h;
    }

    public void fromBytes(ByteBuf buf) {
        this.lookX = buf.readDouble();
        this.lookY = buf.readDouble();
        this.lookZ = buf.readDouble();
        this.held = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.lookX);
        buf.writeDouble(this.lookY);
        buf.writeDouble(this.lookZ);
        buf.writeLong(this.held);
    }

    public static void encode(AuthorityJumpPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityJumpPacket decode(FriendlyByteBuf buf) {
        AuthorityJumpPacket msg = new AuthorityJumpPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final AuthorityJumpPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                AuthorityJumpPacket.authorityJump(message, ((NetworkEvent.Context)context.get()).getSender());
            }
        });
    }

    public static void authorityJump(AuthorityJumpPacket packet, ServerPlayer player) {
        if (player != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY) && WallStickPotion.onWallOrGround((LivingEntity)player)) {
            AuthorityJumpPacket.boop((Entity)player, Math.min((float)packet.held / 4.0f, 5.0f), -packet.lookX, -packet.lookY, -packet.lookZ);
            EffectUtil.buff((LivingEntity)player, ModEffects.AUTHORITY_JUMP, false, 900, false);
        }
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        entity.f_19864_ = true;
        entity.m_20256_(new Vec3(motionX -= x / (double)f * (double)strength, motionY -= y / (double)f * (double)strength, motionZ -= z / (double)f * (double)strength));
    }
}

