/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.TreasuryProjection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.render.item.TreasuryProjectionGauntletRenderer;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TreasuryProjectionGauntlet
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_TREASURY_MODE";

    public TreasuryProjectionGauntlet() {
        super("treasury_projection_gauntlet", new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20163_()) {
            if (!world.f_46443_) {
                this.setMode(stack, (this.getMode(stack) + 1) % 3);
                int mode = this.getMode(stack);
                MutableComponent tt = mode == 0 ? Component.m_237115_((String)"mahoutsukai.treasurygauntlet.targeted") : (mode == 1 ? Component.m_237115_((String)"mahoutsukai.treasurygauntlet.chains") : Component.m_237115_((String)"mahoutsukai.treasurygauntlet.aoe"));
                player.m_5661_((Component)tt, true);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public void setMode(ItemStack gauntlet, int mode) {
        CompoundTag nbt = gauntlet.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_(this.MODE_TAG, mode);
        gauntlet.m_41751_(nbt);
    }

    public int getMode(ItemStack gauntlet) {
        CompoundTag nbt = gauntlet.m_41783_();
        if (nbt != null && nbt.m_128441_(this.MODE_TAG)) {
            return nbt.m_128451_(this.MODE_TAG);
        }
        return 0;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        block10: {
            int numValid;
            ArrayList<ItemStack> projectables;
            int mode;
            block11: {
                mode = this.getMode(stack);
                if (!(player instanceof Player) || player.m_9236_().f_46443_) break block10;
                projectables = this.getProjectables((Player)player);
                numValid = TreasuryProjectionGauntlet.countNonProjected(projectables);
                if (mode != 0) break block11;
                if (projectables.size() <= 0) break block10;
                int mana = MTConfig.TREASURY_PROJECTION_GAUNTLET_MANA_COST;
                ItemStack projectile = projectables.get(player.m_217043_().m_188503_(projectables.size()));
                int cooldown = (int)Math.max(MTConfig.TREASURY_PROJECTION_COOLDOWN_MIN, (double)MTConfig.TREASURY_PROJECTION_COOLDOWN - (double)numValid * MTConfig.TREASURY_PROJECTION_COOLDOWN_INCREASE_PER_SWORD);
                if (count % cooldown != cooldown / 2 || PlayerManaManager.drainMana((Player)player, mana, false, false) != mana) break block10;
                Vec3 v = this.findSpotToCast(player.m_9236_(), (Player)player);
                RandomSource random = player.m_217043_();
                TreasuryProjectionGauntlet.shootWeaponAt(projectile, player.m_9236_(), v, player, random, (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, MTConfig.TREASURY_PROJECTION_SPEED - MTConfig.TREASURY_PROJECTION_SPEED_INCREASE_PER_SWORD * (double)numValid));
                break block10;
            }
            if (mode == 1) {
                int mana = MTConfig.TREASURY_PROJECTION_CHAINS_MANA_COST;
                int cooldown = MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN;
                int cnt = MTConfig.TREASURY_PROJECTION_CHAINS_COUNT;
                if (count % cooldown == cooldown / 2 && count < this.m_8105_(stack)) {
                    if (this.m_8105_(stack) - count <= cooldown) {
                        this.chains((Player)player, true, cnt, mana);
                    } else if (count % 19 * cooldown == 0) {
                        this.chains((Player)player, true, cnt, mana);
                    } else {
                        this.chains((Player)player, false, 1, mana);
                    }
                }
            } else if (mode == 2 && projectables.size() > 0) {
                int mana = MTConfig.TREASURY_PROJECTION_AOE_MANA_COST;
                int cooldown = (int)Math.max(MTConfig.TREASURY_PROJECTION_COOLDOWN_MIN, (double)MTConfig.TREASURY_PROJECTION_AOE_COOLDOWN - (double)numValid * MTConfig.TREASURY_PROJECTION_COOLDOWN_INCREASE_PER_SWORD);
                if (count % cooldown == cooldown / 2 && PlayerManaManager.drainMana((Player)player, mana, false, false) == mana && projectables.size() > 0) {
                    ItemStack projectile = projectables.get(player.m_217043_().m_188503_(projectables.size()));
                    int numSpawns = (int)Math.min(MTConfig.TREASURY_PROJECTION_AOE_MAX_SPAWNS, (double)numValid / MTConfig.TREASURY_PROJECTION_AOE_SWORDS_PER_SPAWN);
                    for (int i = 0; i < Math.max(1, numSpawns); ++i) {
                        TreasuryProjectionGauntlet.behindShoot(projectile, player.m_9236_(), player, player.m_217043_(), (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, MTConfig.TREASURY_PROJECTION_SPEED - MTConfig.TREASURY_PROJECTION_SPEED_INCREASE_PER_SWORD * (double)numValid));
                    }
                }
            }
        }
        super.m_5929_(level, player, stack, count);
    }

    public static int countNonProjected(ArrayList<ItemStack> lst) {
        int ret = 0;
        HashSet<String> seen = new HashSet<String>();
        if (lst != null) {
            for (ItemStack s : lst) {
                if (ProjectionSpellEffect.getProjected(s) || seen.contains(Utils.getRegistryName(s.m_41720_()))) continue;
                ++ret;
                seen.add(Utils.getRegistryName(s.m_41720_()));
            }
        }
        return ret;
    }

    protected boolean isArrow(ItemStack stack) {
        boolean sword;
        Item tmpi = stack.m_41720_();
        if (stack.m_41619_()) {
            return false;
        }
        List<? extends String> white = MTConfig.TREASURY_PROJECTION_WHITELIST;
        List<? extends String> black = MTConfig.TREASURY_PROJECTION_BLACKLIST;
        boolean allow_all = MTConfig.TREASURY_PROJECTION_ALLOW_ALL;
        boolean deny_all = MTConfig.TREASURY_PROJECTION_DENY_ALL;
        boolean bl = sword = tmpi instanceof SwordItem || tmpi instanceof DiggerItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem || tmpi instanceof TridentItem || MahouTsukaiMod.jousting.treasuryProjection(tmpi);
        if (deny_all) {
            sword = false;
        }
        boolean inwhite = false;
        boolean inblack = false;
        inwhite = EffectUtil.inItemBlacklist(stack.m_41720_(), white);
        inblack = EffectUtil.inItemBlacklist(stack.m_41720_(), black);
        if (inblack) {
            return false;
        }
        return sword || inwhite || allow_all;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public Vec3 findSpotToCast(Level world, Player player) {
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.m_9236_(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
        Vec3 v = e instanceof LivingEntity ? e.m_20182_().m_82520_(0.0, (double)(e.m_20206_() / 2.0f), 0.0) : this.getTargetBlock(player);
        return v;
    }

    public ArrayList<ItemStack> getProjectables(Player player) {
        ItemStack stack2;
        int j;
        int z;
        IItemHandler inv;
        ItemStack stack1;
        int i;
        int size = player.m_150109_().f_35974_.size();
        ArrayList<ItemStack> projectables = new ArrayList<ItemStack>();
        if (!MTConfig.TREASURY_PROJECTION_ENDER_CHEST_ONLY) {
            for (i = 0; i < size; ++i) {
                stack1 = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (this.isArrow(stack1)) {
                    projectables.add(stack1);
                }
                if ((inv = Utils.getInventory(stack1)) == null) continue;
                z = inv.getSlots();
                for (j = 0; j < z; ++j) {
                    stack2 = inv.getStackInSlot(j);
                    if (!this.isArrow(stack2)) continue;
                    projectables.add(stack2);
                }
            }
        }
        for (i = 0; i < player.m_36327_().m_6643_(); ++i) {
            stack1 = player.m_36327_().m_8020_(i);
            if (this.isArrow(stack1)) {
                projectables.add(stack1);
            }
            if ((inv = Utils.getInventory(stack1)) == null) continue;
            z = inv.getSlots();
            for (j = 0; j < z; ++j) {
                stack2 = inv.getStackInSlot(j);
                if (!this.isArrow(stack2)) continue;
                projectables.add(stack2);
            }
        }
        return projectables;
    }

    public Vec3 getTargetBlock(Player player) {
        Vec3 target;
        HitResult result = Utils.rayTraceEyes((LivingEntity)player, MTConfig.GLOBAL_LOOK_RANGE);
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.m_9236_(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
        if (result.m_6662_() == HitResult.Type.BLOCK && e == null) {
            BlockHitResult br = (BlockHitResult)result;
            target = new Vec3((double)br.m_82425_().m_123341_() + 0.5, (double)br.m_82425_().m_123342_(), (double)br.m_82425_().m_123343_() + 0.5).m_82520_(0.0, 1.0, 0.0);
        } else if (e != null) {
            target = e.m_20299_(1.0f);
        } else {
            Vec3 v = player.m_20252_(0.0f);
            Vec3 v2 = new Vec3(v.f_82479_ * (double)MTConfig.GLOBAL_LOOK_RANGE, v.f_82480_ * (double)MTConfig.GLOBAL_LOOK_RANGE, v.f_82481_ * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3 v3 = player.m_20299_(1.0f).m_82549_(v2);
            while (Utils.isBlockAir(player.m_9236_(), Utils.toBlockPos(v3)) && v3.f_82480_ > 0.0) {
                v3 = v3.m_82549_(new Vec3(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public static void shootWeaponAt(ItemStack stack, Level world, Vec3 pos, LivingEntity player, RandomSource random, float speed) {
        GateWeaponProjectileEntity weapon;
        int d = MTConfig.TREASURY_PROJECTION_DISTANCE;
        int d2 = MTConfig.TREASURY_PROJECTION_MIN_DISTANCE;
        int tries = 0;
        do {
            ++tries;
            int circleDegrees = random.m_188503_(360);
            int groundDegrees = random.m_188503_(70) + 20;
            int distance = random.m_188503_(d2) + (d - d2);
            double height = (double)distance * Math.cos(EffectUtil.toRad(groundDegrees));
            double radius = Math.sqrt((double)(distance * distance) - height * height);
            double zplus = radius * Math.sin(EffectUtil.toRad(circleDegrees));
            double xplus = -radius * Math.cos(EffectUtil.toRad(circleDegrees));
            weapon = new GateWeaponProjectileEntity(world, pos.f_82479_ + xplus, pos.f_82480_ + height, pos.f_82481_ + zplus, stack.m_41777_(), (Entity)player, speed);
            List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.TREASURY_WEAPONS);
            weapon.setColor(MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 1.0f, 0.0f, 0.0f, 0.0f);
            weapon.f_19858_ = groundDegrees;
            weapon.f_19857_ = circleDegrees - 90;
            weapon.m_5602_((Entity)player);
            Vec3 aim = weapon.m_20182_().m_82546_(pos);
            weapon.m_6686_(-aim.f_82479_, -aim.f_82480_, -aim.f_82481_, 3.0f, 4.0f);
        } while (!world.m_46859_(Utils.toBlockPos(weapon.m_20182_())) && tries < 20);
        world.m_7967_((Entity)weapon);
        if (player instanceof ServerPlayer) {
            ModTriggers.TREASURY_PROJECTION.trigger((ServerPlayer)player);
        }
    }

    public static void behindShoot(ItemStack stack, Level world, LivingEntity player, RandomSource random, float speed) {
        GateWeaponProjectileEntity weapon;
        int tries = 0;
        do {
            Vec3 playerpos;
            ++tries;
            float scale = player.m_217043_().m_188501_() * 4.0f + 3.0f;
            float height = player.m_217043_().m_188501_() * 3.0f + 1.0f;
            Vec3 look = player.m_20154_();
            Vec3 playerperp = playerpos = player.m_20182_();
            playerperp = playerperp.m_82549_(look.m_82541_().m_82490_(-3.0));
            playerperp = player.m_217043_().m_188499_() ? playerperp.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_19857_ + 90.0f)).m_82541_().m_82490_((double)player.m_217043_().m_188503_(4) - 0.3).m_82490_(2.0)) : playerperp.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_19857_ - 90.0f)).m_82541_().m_82490_((double)player.m_217043_().m_188503_(4) - 0.3).m_82490_(2.0));
            playerperp = playerperp.m_82549_(Vec3.m_82498_((float)(player.f_19858_ - 90.0f), (float)player.f_19857_).m_82541_().m_82490_((double)player.m_217043_().m_188503_(4) + 1.8).m_82490_(2.0));
            weapon = new GateWeaponProjectileEntity(world, playerperp.f_82479_, playerperp.f_82480_, playerperp.f_82481_, stack.m_41777_(), (Entity)player, speed);
            List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.TREASURY_WEAPONS);
            weapon.setColor(MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 1.0f, 0.0f, 0.0f, 0.0f);
            weapon.f_19858_ = player.f_19858_;
            weapon.f_19857_ = player.f_19857_;
            Vec3 pos = weapon.m_20182_().m_82549_(player.m_20154_());
            weapon.m_5602_((Entity)player);
            Vec3 aim = weapon.m_20182_().m_82546_(pos);
            weapon.m_6686_(-aim.f_82479_, -aim.f_82480_, -aim.f_82481_, 3.0f, 4.0f);
        } while (!world.m_46859_(Utils.toBlockPos(weapon.m_20182_())) && tries < 20);
        world.m_7967_((Entity)weapon);
        if (player instanceof ServerPlayer) {
            ModTriggers.TREASURY_PROJECTION.trigger((ServerPlayer)player);
        }
    }

    public void chains(Player player, boolean prison, int tospawn, int mana) {
        if (PlayerManaManager.drainMana(player, mana * tospawn, false, false) == mana * tospawn) {
            float w;
            float h;
            Vec3 v;
            Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.m_9236_(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON));
            boolean entity = false;
            if (e instanceof LivingEntity) {
                v = e.m_20182_();
                h = e.m_20206_() + 2.0f;
                w = e.m_20205_() + 1.5f;
                entity = true;
            } else {
                v = this.getTargetBlock(player);
                h = 5.0f;
                w = 3.0f;
            }
            if (prison) {
                int i;
                ArrayList<Integer> degreeList = new ArrayList<Integer>();
                for (i = 0; i < tospawn; ++i) {
                    int q = 360 / tospawn;
                    int init = q * i;
                    degreeList.add(init += player.m_217043_().m_188503_(q / 3) - q / 6);
                }
                for (i = 0; i < tospawn; ++i) {
                    if (i >= degreeList.size()) continue;
                    int circleDegrees = (Integer)degreeList.get(i);
                    double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                    double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                    Vec3 chainpos = v.m_82520_(0.0, (double)h, 0.0).m_82549_(new Vec3(xplus, 0.0, zplus));
                    Vec3 aimTo = v.m_82546_(chainpos).m_82541_().m_82520_((double)(player.m_217043_().m_188501_() * 2.0f - 1.0f), (double)player.m_217043_().m_188501_() - 0.5, (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f)).m_82541_().m_82490_(40.0);
                    BlockHitResult raytrace = player.m_9236_().m_45547_(new ClipContext(chainpos, chainpos.m_82549_(aimTo), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
                    Vec3 pos = EffectUtil.fromBlockPos(raytrace.m_82425_());
                    if (Utils.isBlockAir(player.m_9236_(), Utils.toBlockPos(pos))) continue;
                    List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.TREASURY_CHAINS);
                    GateChainEntity chain = new GateChainEntity(player.m_9236_(), MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 1.0f, chainpos, pos);
                    Vec3 aim = chain.m_20182_().m_82546_(pos);
                    chain.shoot(-aim.f_82479_, -aim.f_82480_, -aim.f_82481_);
                    chain.setCircleSize(1.0f);
                    player.m_9236_().m_5594_(null, Utils.toBlockPos(chain.m_20182_()), (SoundEvent)ModSounds.CHAINS.get(), SoundSource.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                    player.m_9236_().m_7967_((Entity)chain);
                }
            } else if (entity) {
                int circleDegrees = player.m_217043_().m_188503_(360);
                double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                Vec3 chainpos = v.m_82520_(0.0, (double)h, 0.0).m_82549_(new Vec3(xplus, 0.0, zplus));
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.TREASURY_CHAINS);
                Vec3 pos = e.m_20182_();
                GateChainEntity chain = new GateChainEntity(player.m_9236_(), MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 1.0f, chainpos, pos);
                Vec3 aim = chain.m_20182_().m_82546_(pos);
                chain.shoot(-aim.f_82479_, -aim.f_82480_, -aim.f_82481_);
                chain.setCircleSize(1.0f);
                player.m_9236_().m_5594_(null, Utils.toBlockPos(chain.m_20182_()), (SoundEvent)ModSounds.CHAINS.get(), SoundSource.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                player.m_9236_().m_7967_((Entity)chain);
            }
        }
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(TreasuryProjectionGauntletRenderer::new);
    }
}

