/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.circuits;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ManaCircuitBlock
extends BlockTileEntity<ManaCircuitTileEntity> {
    public static final AABB boundingBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AABB boundingBoxE = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public ManaCircuitBlock() {
        BlockBehaviour.Properties.m_284310_();
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_(), "mana_circuit");
    }

    @Override
    public Class<ManaCircuitTileEntity> getTileEntityClass() {
        return ManaCircuitTileEntity.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ManaCircuitTileEntity(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult res) {
        return ManaCircuitBlock.chargeCircuitBlock(worldIn, pos, playerIn) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public static boolean chargeCircuitBlock(Level worldIn, BlockPos pos, Player playerIn) {
        BlockEntity tte;
        if (!worldIn.f_46443_ && (tte = worldIn.m_7702_(pos)) instanceof ManaCircuitTileEntity) {
            ManaCircuitTileEntity te = (ManaCircuitTileEntity)tte;
            if (te.getOwnerUUID() == null) {
                te.setOwnerUUID(playerIn.m_20148_());
            }
            if (playerIn.m_20163_()) {
                te.setOn(!te.isOn());
                te.sendUpdates();
            } else if (playerIn != null) {
                if (playerIn.m_21205_().m_41720_() instanceof FaeEssence) {
                    if (playerIn.m_20148_().equals(te.getOwnerUUID())) {
                        te.setFae(!te.getFae());
                        te.sendUpdates();
                    }
                } else {
                    IMahou mahou = Utils.getPlayerMahou(playerIn);
                    if (mahou != null) {
                        int MAX_MANA;
                        double chargeRate = mahou.getChargeRate();
                        int playerMaxMana = mahou.getMaxMana();
                        int manaDifference = (int)Math.ceil((double)playerMaxMana * chargeRate);
                        int storedMana = te.getMana();
                        if (storedMana < (MAX_MANA = te.getMaxMana())) {
                            manaDifference = Math.min(manaDifference, MAX_MANA - storedMana);
                            manaDifference = PlayerManaManager.chargeCircuit(playerIn, manaDifference);
                            te.setMana(storedMana + manaDifference);
                        }
                        if ((storedMana = te.getMana()) >= MAX_MANA) {
                            te.setMana(MAX_MANA);
                        }
                        te.sendUpdates();
                    }
                }
            }
            return true;
        }
        return true;
    }
}

