/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.config.LandscapeType;

public class ChunkHeightmap {
    private int height;
    private final LandscapeType type;
    private final int groundLevel;

    public ChunkHeightmap(LandscapeType type, int groundLevel) {
        this.groundLevel = groundLevel;
        this.type = type;
        this.height = Short.MIN_VALUE;
    }

    public void update(int y) {
        int current = this.height;
        if (y <= current) {
            return;
        }
        if (this.type == LandscapeType.CAVERN) {
            int base = Math.max(this.groundLevel - 20, 1);
            if (y > 100 || y < base) {
                return;
            }
            if (y == 100) {
                y = 127;
            }
        }
        this.height = y;
    }

    public int getHeight() {
        return this.height;
    }
}

