/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import mcjty.lostcities.worldgen.lost.Orientation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record ChunkCoord(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
    public ChunkCoord offset(int dx, int dz) {
        return new ChunkCoord(this.dimension, this.chunkX + dx, this.chunkZ + dz);
    }

    public ChunkCoord east() {
        return new ChunkCoord(this.dimension, this.chunkX + 1, this.chunkZ);
    }

    public ChunkCoord west() {
        return new ChunkCoord(this.dimension, this.chunkX - 1, this.chunkZ);
    }

    public ChunkCoord north() {
        return new ChunkCoord(this.dimension, this.chunkX, this.chunkZ - 1);
    }

    public ChunkCoord south() {
        return new ChunkCoord(this.dimension, this.chunkX, this.chunkZ + 1);
    }

    public ChunkCoord northWest() {
        return new ChunkCoord(this.dimension, this.chunkX - 1, this.chunkZ - 1);
    }

    public ChunkCoord northEast() {
        return new ChunkCoord(this.dimension, this.chunkX + 1, this.chunkZ - 1);
    }

    public ChunkCoord southWest() {
        return new ChunkCoord(this.dimension, this.chunkX - 1, this.chunkZ + 1);
    }

    public ChunkCoord southEast() {
        return new ChunkCoord(this.dimension, this.chunkX + 1, this.chunkZ + 1);
    }

    public ChunkCoord lower(Orientation o) {
        return switch (o) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X -> new ChunkCoord(this.dimension, this.chunkX - 1, this.chunkZ);
            case Orientation.Z -> new ChunkCoord(this.dimension, this.chunkX, this.chunkZ - 1);
        };
    }

    public ChunkCoord higher(Orientation o) {
        return switch (o) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X -> new ChunkCoord(this.dimension, this.chunkX + 1, this.chunkZ);
            case Orientation.Z -> new ChunkCoord(this.dimension, this.chunkX, this.chunkZ + 1);
        };
    }

    public int getCoord(Orientation o) {
        return switch (o) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X -> this.chunkX;
            case Orientation.Z -> this.chunkZ;
        };
    }

    @Override
    public String toString() {
        return "ChunkCoord{dimension=" + this.dimension + ", chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + "}";
    }
}

