/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.regassets.WorldStyleRE;
import mcjty.lostcities.worldgen.lost.regassets.data.BiomeMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.CityBiomeMultiplier;
import mcjty.lostcities.worldgen.lost.regassets.data.CitySphereSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.CityStyleSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PartSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredSettings;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class WorldStyle
implements ILostCityAsset {
    private final ResourceLocation name;
    private final String outsideStyle;
    private final CitySphereSettings citysphereSettings;
    private final ScatteredSettings scatteredSettings;
    @Nonnull
    private final PartSelector partSelector;
    private final List<Pair<Predicate<Holder<Biome>>, Pair<Float, String>>> cityStyleSelector = new ArrayList<Pair<Predicate<Holder<Biome>>, Pair<Float, String>>>();
    private final List<Pair<Predicate<Holder<Biome>>, Float>> cityBiomeMultiplier = new ArrayList<Pair<Predicate<Holder<Biome>>, Float>>();

    public WorldStyle(WorldStyleRE object) {
        this.name = object.getRegistryName();
        this.citysphereSettings = object.getCitysphereSettings();
        this.scatteredSettings = object.getScatteredSettings();
        this.partSelector = object.getPartSelector();
        this.outsideStyle = object.getOutsideStyle();
        for (CityStyleSelector selector : object.getCityStyleSelectors()) {
            BiomeMatcher predicate = biomeHolder -> true;
            if (selector.biomeMatcher() != null) {
                predicate = selector.biomeMatcher();
            }
            this.cityStyleSelector.add((Pair<Predicate<Holder<Biome>>, Pair<Float, String>>)Pair.of((Object)predicate, (Object)Pair.of((Object)Float.valueOf(selector.factor()), (Object)selector.citystyle())));
        }
        if (object.getCityBiomeMultipliers() != null) {
            for (CityBiomeMultiplier multiplier : object.getCityBiomeMultipliers()) {
                this.cityBiomeMultiplier.add((Pair<Predicate<Holder<Biome>>, Float>)Pair.of((Object)multiplier.biomeMatcher(), (Object)Float.valueOf(multiplier.multiplier())));
            }
        }
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    public String getOutsideStyle() {
        return this.outsideStyle;
    }

    @Nonnull
    public PartSelector getPartSelector() {
        return this.partSelector;
    }

    public CitySphereSettings getCitysphereSettings() {
        return this.citysphereSettings;
    }

    @Nullable
    public ScatteredSettings getScatteredSettings() {
        return this.scatteredSettings;
    }

    public float getCityChanceMultiplier(IDimensionInfo provider, int chunkX, int chunkZ) {
        Holder<Biome> biome = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.getType(), chunkX, chunkZ)).getMainBiome();
        for (Pair<Predicate<Holder<Biome>>, Float> pair : this.cityBiomeMultiplier) {
            if (!((Predicate)pair.getLeft()).test(biome)) continue;
            return ((Float)pair.getRight()).floatValue();
        }
        return 1.0f;
    }

    public String getRandomCityStyle(IDimensionInfo provider, int chunkX, int chunkZ, Random random) {
        Holder<Biome> biome = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.getType(), chunkX, chunkZ)).getMainBiome();
        ArrayList<Pair> ct = new ArrayList<Pair>();
        for (Pair<Predicate<Holder<Biome>>, Pair<Float, String>> pair : this.cityStyleSelector) {
            if (!((Predicate)pair.getKey()).test(biome)) continue;
            ct.add((Pair)pair.getValue());
        }
        Pair randomFromList = Tools.getRandomFromList(random, ct, Pair::getLeft);
        if (randomFromList == null) {
            return null;
        }
        return (String)randomFromList.getRight();
    }
}

