/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.QualityRandom;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.regassets.data.RailwayParts;

public class Railway {
    public static final int RAILWAY_LEVEL_OFFSET = -3;
    private static final Map<ChunkCoord, RailChunkInfo> RAIL_INFO = new HashMap<ChunkCoord, RailChunkInfo>();

    public static void cleanCache() {
        RAIL_INFO.clear();
    }

    private static RailChunkInfo getRailChunkTypeInternal(int chunkX, int chunkZ, IDimensionInfo provider) {
        QualityRandom randomRailChunkType = new QualityRandom(provider.getSeed() + (long)chunkZ * 2600003897L + (long)chunkX * 43600002517L);
        randomRailChunkType.nextFloat();
        randomRailChunkType.nextFloat();
        LostCityProfile profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
        RailwayParts railwayParts = provider.getWorldStyle().getPartSelector().railwayParts();
        float r = randomRailChunkType.nextFloat();
        int mx = Math.floorMod(chunkX + 1, 20);
        int mz = Math.floorMod(chunkZ + 1, 20);
        if (mx == 0 && mz == 10) {
            if (!BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile)) {
                if (profile.RAILWAYS_CAN_END) {
                    boolean cityWest;
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 10, chunkZ, provider, profile) || BuildingInfo.isCityRaw(chunkX + 10, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX + 10, chunkZ + 10, provider, profile);
                    boolean bl = cityWest = BuildingInfo.isCityRaw(chunkX - 10, chunkZ, provider, profile) || BuildingInfo.isCityRaw(chunkX - 10, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX - 10, chunkZ + 10, provider, profile);
                    if (!cityEast && !cityWest) {
                        return RailChunkInfo.NOTHING;
                    }
                    if (!cityEast) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.WEST, -3, 3);
                    }
                    if (!cityWest) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.EAST, -3, 3);
                    }
                }
                return new RailChunkInfo(RailChunkType.HORIZONTAL, RailDirection.BI, -3, 3);
            }
            return Railway.getStationType(chunkX, chunkZ, provider, profile, r, 3, randomRailChunkType.nextFloat() < 0.5f ? railwayParts.stationOpen() : railwayParts.stationOpenRoof());
        }
        if (mx == 10 && mz == 0) {
            if (!BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile)) {
                if (profile.RAILWAYS_CAN_END) {
                    boolean cityWest;
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 10, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX + 10, chunkZ + 10, provider, profile);
                    boolean bl = cityWest = BuildingInfo.isCityRaw(chunkX - 10, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX - 10, chunkZ + 10, provider, profile);
                    if (!cityEast && !cityWest) {
                        return RailChunkInfo.NOTHING;
                    }
                    if (!cityEast) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.WEST, -3, 2);
                    }
                    if (!cityWest) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.EAST, -3, 2);
                    }
                }
                return new RailChunkInfo(RailChunkType.HORIZONTAL, RailDirection.BI, -3, 2);
            }
            return Railway.getStationType(chunkX, chunkZ, provider, profile, r, 2, randomRailChunkType.nextFloat() < 0.5f ? railwayParts.stationOpen() : railwayParts.stationOpenRoof());
        }
        if (mx == 10 && mz == 10) {
            if (!BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile)) {
                if (profile.RAILWAYS_CAN_END) {
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 10, chunkZ, provider, profile);
                    boolean cityWest = BuildingInfo.isCityRaw(chunkX - 10, chunkZ, provider, profile);
                    if (!cityEast && !cityWest) {
                        return RailChunkInfo.NOTHING;
                    }
                    if (!cityEast) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.WEST, -3, 1);
                    }
                    if (!cityWest) {
                        return new RailChunkInfo(RailChunkType.RAILS_END_HERE, RailDirection.EAST, -3, 1);
                    }
                }
                return new RailChunkInfo(RailChunkType.HORIZONTAL, RailDirection.BI, -3, 1);
            }
            return Railway.getStationType(chunkX, chunkZ, provider, profile, r, 1, randomRailChunkType.nextFloat() < 0.5f ? railwayParts.stationOpen() : railwayParts.stationOpenRoof());
        }
        if (mx == 0 && mz == 0) {
            return RailChunkInfo.NOTHING;
        }
        if (mz == 0 || mz == 10) {
            if (mx >= 16 && mz != 0 || mx >= 6 && mx <= 9) {
                RailChunkInfo adjacent = Railway.getRailChunkType(chunkX + 1, chunkZ, provider, profile);
                RailDirection direction = adjacent.getDirection();
                if (direction == RailDirection.BI || adjacent.getType() == RailChunkType.RAILS_END_HERE) {
                    direction = RailDirection.WEST;
                }
                return Railway.testAdjacentRailChunk(r, adjacent, direction, chunkX - 1, chunkZ, provider, profile);
            }
            if (mx >= 1 && mx <= 4 && mz != 0 || mx >= 11 && mx <= 14) {
                RailChunkInfo adjacent = Railway.getRailChunkType(chunkX - 1, chunkZ, provider, profile);
                RailDirection direction = adjacent.getDirection();
                if (direction == RailDirection.BI || adjacent.getType() == RailChunkType.RAILS_END_HERE) {
                    direction = RailDirection.EAST;
                }
                return Railway.testAdjacentRailChunk(r, adjacent, direction, chunkX + 1, chunkZ, provider, profile);
            }
            if (mz == 0 && mx == 5) {
                if (profile.RAILWAYS_CAN_END) {
                    boolean cityWest = BuildingInfo.isCityRaw(chunkX - 5, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX - 5, chunkZ + 10, provider, profile);
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 5, chunkZ, provider, profile);
                    if (!cityEast && !cityWest) {
                        return RailChunkInfo.NOTHING;
                    }
                }
                return new RailChunkInfo(RailChunkType.DOUBLE_BEND, RailDirection.EAST, -3, 1);
            }
            if (mz == 0 && mx == 15) {
                if (profile.RAILWAYS_CAN_END) {
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 5, chunkZ - 10, provider, profile) || BuildingInfo.isCityRaw(chunkX + 5, chunkZ + 10, provider, profile);
                    boolean cityWest = BuildingInfo.isCityRaw(chunkX - 5, chunkZ, provider, profile);
                    if (!cityEast && !cityWest) {
                        return RailChunkInfo.NOTHING;
                    }
                }
                return new RailChunkInfo(RailChunkType.DOUBLE_BEND, RailDirection.WEST, -3, 1);
            }
            if (mz == 10 && mx == 5) {
                if (profile.RAILWAYS_CAN_END) {
                    RailChunkInfo typeSouth;
                    RailChunkInfo typeNorth;
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 5, chunkZ, provider, profile);
                    boolean cityWest = BuildingInfo.isCityRaw(chunkX - 5, chunkZ, provider, profile);
                    if (!cityEast && !cityWest && (typeNorth = Railway.getRailChunkType(chunkX, chunkZ - 10, provider, profile)).getType() == RailChunkType.NONE && (typeSouth = Railway.getRailChunkType(chunkX, chunkZ - 10, provider, profile)).getType() == RailChunkType.NONE) {
                        return RailChunkInfo.NOTHING;
                    }
                }
                return new RailChunkInfo(RailChunkType.THREE_SPLIT, RailDirection.EAST, -3, 3);
            }
            if (mz == 10 && mx == 15) {
                if (profile.RAILWAYS_CAN_END) {
                    RailChunkInfo typeSouth;
                    RailChunkInfo typeNorth;
                    boolean cityEast = BuildingInfo.isCityRaw(chunkX + 5, chunkZ, provider, profile);
                    boolean cityWest = BuildingInfo.isCityRaw(chunkX - 5, chunkZ, provider, profile);
                    if (!cityEast && !cityWest && (typeNorth = Railway.getRailChunkType(chunkX, chunkZ - 10, provider, profile)).getType() == RailChunkType.NONE && (typeSouth = Railway.getRailChunkType(chunkX, chunkZ - 10, provider, profile)).getType() == RailChunkType.NONE) {
                        return RailChunkInfo.NOTHING;
                    }
                }
                return new RailChunkInfo(RailChunkType.THREE_SPLIT, RailDirection.WEST, -3, 3);
            }
            return RailChunkInfo.NOTHING;
        }
        if (mx == 5) {
            if (profile.RAILWAYS_CAN_END) {
                RailChunkInfo typeNorth = Railway.getRailChunkType(chunkX, chunkZ - mz % 10, provider, profile);
                RailChunkInfo typeSouth = Railway.getRailChunkType(chunkX, chunkZ - mz % 10 + 10, provider, profile);
                if (typeNorth.getType() == RailChunkType.NONE || typeSouth.getType() == RailChunkType.NONE) {
                    return RailChunkInfo.NOTHING;
                }
            }
            return new RailChunkInfo(RailChunkType.VERTICAL, RailDirection.EAST, -3, 1);
        }
        if (mx == 15) {
            if (profile.RAILWAYS_CAN_END) {
                RailChunkInfo typeNorth = Railway.getRailChunkType(chunkX, chunkZ - mz % 10, provider, profile);
                RailChunkInfo typeSouth = Railway.getRailChunkType(chunkX, chunkZ - mz % 10 + 10, provider, profile);
                if (typeNorth.getType() == RailChunkType.NONE || typeSouth.getType() == RailChunkType.NONE) {
                    return RailChunkInfo.NOTHING;
                }
            }
            return new RailChunkInfo(RailChunkType.VERTICAL, RailDirection.WEST, -3, 1);
        }
        return RailChunkInfo.NOTHING;
    }

    private static RailChunkInfo getStationType(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile, float r, int rails, String part) {
        int cityLevel = BuildingInfo.getCityLevel(chunkX, chunkZ, provider);
        if (cityLevel > 2) {
            return new RailChunkInfo(RailChunkType.STATION_UNDERGROUND, RailDirection.BI, -3, rails);
        }
        int highwayX = Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile);
        int highwayZ = Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile);
        if (highwayX != -1 && cityLevel >= highwayX || highwayZ != -1 && cityLevel >= highwayZ) {
            return new RailChunkInfo(RailChunkType.STATION_UNDERGROUND, RailDirection.BI, -3, rails);
        }
        highwayZ = Highway.getZHighwayLevel(chunkX - 1, chunkZ, provider, profile);
        if (highwayZ != -1 && cityLevel >= highwayZ) {
            return new RailChunkInfo(RailChunkType.STATION_UNDERGROUND, RailDirection.BI, -3, rails);
        }
        highwayZ = Highway.getZHighwayLevel(chunkX + 1, chunkZ, provider, profile);
        if (highwayZ != -1 && cityLevel >= highwayZ) {
            return new RailChunkInfo(RailChunkType.STATION_UNDERGROUND, RailDirection.BI, -3, rails);
        }
        return r < 0.5f ? new RailChunkInfo(RailChunkType.STATION_SURFACE, RailDirection.BI, cityLevel, rails, part) : new RailChunkInfo(RailChunkType.STATION_UNDERGROUND, RailDirection.BI, -3, rails);
    }

    public static RailChunkInfo getRailChunkType(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        ChunkCoord key = new ChunkCoord(provider.getType(), chunkX, chunkZ);
        if (RAIL_INFO.containsKey(key)) {
            return RAIL_INFO.get(key);
        }
        RailChunkInfo info = Railway.getRailChunkTypeInternal(chunkX, chunkZ, provider);
        if ((provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && CitySphere.onCitySphereBorder(chunkX, chunkZ, provider)) {
            info = RailChunkInfo.NOTHING;
        } else if (info.getType().isStation()) {
            if (!profile.RAILWAY_STATIONS_ENABLED) {
                info = RailChunkInfo.NOTHING;
            }
        } else if (!profile.RAILWAYS_ENABLED) {
            info = RailChunkInfo.NOTHING;
        }
        RAIL_INFO.put(key, info);
        return info;
    }

    private static RailChunkInfo testAdjacentRailChunk(float r, RailChunkInfo adjacent, RailDirection direction, int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        switch (adjacent.getType()) {
            case NONE: {
                return RailChunkInfo.NOTHING;
            }
            case STATION_SURFACE: {
                int highwayX = Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile);
                int highwayZ = Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile);
                if (highwayX != -1 && adjacent.getLevel() == highwayX || highwayZ != -1 && adjacent.getLevel() == highwayZ) {
                    r = 1.0f;
                }
                if (r < 0.4f) {
                    return new RailChunkInfo(RailChunkType.STATION_EXTENSION_SURFACE, direction, adjacent.getLevel(), adjacent.getRails());
                }
                if ((adjacent.getLevel() & 1) == 0) {
                    return new RailChunkInfo(RailChunkType.GOING_DOWN_ONE_FROM_SURFACE, direction, adjacent.getLevel() - 1, adjacent.getRails());
                }
                return new RailChunkInfo(RailChunkType.GOING_DOWN_TWO_FROM_SURFACE, direction, adjacent.getLevel() - 2, adjacent.getRails());
            }
            case STATION_UNDERGROUND: {
                return r < 0.4f ? new RailChunkInfo(RailChunkType.STATION_EXTENSION_UNDERGROUND, direction, adjacent.getLevel(), adjacent.getRails()) : new RailChunkInfo(RailChunkType.HORIZONTAL, direction, adjacent.getLevel(), adjacent.getRails());
            }
            case STATION_EXTENSION_SURFACE: {
                if ((adjacent.getLevel() & 1) == 0) {
                    return new RailChunkInfo(RailChunkType.GOING_DOWN_ONE_FROM_SURFACE, direction, adjacent.getLevel() - 1, adjacent.getRails());
                }
                return new RailChunkInfo(RailChunkType.GOING_DOWN_TWO_FROM_SURFACE, direction, adjacent.getLevel() - 2, adjacent.getRails());
            }
            case STATION_EXTENSION_UNDERGROUND: {
                return new RailChunkInfo(RailChunkType.HORIZONTAL, direction, adjacent.getLevel(), adjacent.getRails());
            }
            case GOING_DOWN_FURTHER: 
            case GOING_DOWN_ONE_FROM_SURFACE: 
            case GOING_DOWN_TWO_FROM_SURFACE: {
                if (adjacent.getLevel() == -3) {
                    return new RailChunkInfo(RailChunkType.HORIZONTAL, direction, adjacent.getLevel(), adjacent.getRails());
                }
                return new RailChunkInfo(RailChunkType.GOING_DOWN_FURTHER, direction, adjacent.getLevel() - 2, adjacent.getRails());
            }
            case THREE_SPLIT: {
                break;
            }
            case VERTICAL: {
                break;
            }
            case DOUBLE_BEND: {
                break;
            }
            case RAILS_END_HERE: {
                if (direction == adjacent.getDirection()) {
                    return new RailChunkInfo(RailChunkType.HORIZONTAL, direction, adjacent.getLevel(), adjacent.getRails());
                }
                return RailChunkInfo.NOTHING;
            }
            case HORIZONTAL: {
                return adjacent;
            }
        }
        throw new RuntimeException("This is really impossible!");
    }

    public static class RailChunkInfo {
        private final RailChunkType type;
        private final RailDirection direction;
        private final int level;
        private final int rails;
        private final String part;
        public static final RailChunkInfo NOTHING = new RailChunkInfo(RailChunkType.NONE, RailDirection.BI, 0, 0);

        public RailChunkInfo(RailChunkType type, RailDirection direction, int level, int rails) {
            this(type, direction, level, rails, null);
        }

        public RailChunkInfo(RailChunkType type, RailDirection direction, int level, int rails, String part) {
            this.type = type;
            this.direction = direction;
            this.level = level;
            this.rails = rails;
            this.part = part;
        }

        public RailChunkType getType() {
            return this.type;
        }

        public RailDirection getDirection() {
            return this.direction;
        }

        public int getLevel() {
            return this.level;
        }

        public int getRails() {
            return this.rails;
        }

        public String getPart() {
            return this.part;
        }
    }

    public static enum RailDirection {
        BI,
        WEST,
        EAST;

    }
}

