/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.PerlinNoiseGenerator14;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Orientation;

public class Highway {
    private static PerlinNoiseGenerator14 perlinX = null;
    private static PerlinNoiseGenerator14 perlinZ = null;
    private static final Map<ChunkCoord, Integer> X_HIGHWAY_LEVEL_CACHE = new HashMap<ChunkCoord, Integer>();
    private static final Map<ChunkCoord, Integer> Z_HIGHWAY_LEVEL_CACHE = new HashMap<ChunkCoord, Integer>();

    private static void makePerlin(long seed) {
        if (perlinX == null) {
            perlinX = new PerlinNoiseGenerator14(seed, 4);
        }
        if (perlinZ == null) {
            perlinZ = new PerlinNoiseGenerator14(seed, 4);
        }
    }

    public static void cleanCache() {
        perlinX = null;
        perlinZ = null;
        X_HIGHWAY_LEVEL_CACHE.clear();
        Z_HIGHWAY_LEVEL_CACHE.clear();
    }

    public static boolean hasHighway(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        if (Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile) >= 0) {
            return true;
        }
        return Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile) >= 0;
    }

    public static int getXHighwayLevel(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Highway.getHighwayLevel(provider, profile, X_HIGHWAY_LEVEL_CACHE, cp -> Highway.hasXHighway(cp, profile), Orientation.X, new ChunkCoord(provider.getType(), chunkX, chunkZ));
    }

    public static int getZHighwayLevel(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Highway.getHighwayLevel(provider, profile, Z_HIGHWAY_LEVEL_CACHE, cp -> Highway.hasZHighway(cp, profile), Orientation.Z, new ChunkCoord(provider.getType(), chunkX, chunkZ));
    }

    private static int getHighwayLevel(IDimensionInfo provider, LostCityProfile profile, Map<ChunkCoord, Integer> cache, Function<ChunkCoord, Boolean> hasHighway, Orientation orientation, ChunkCoord cp) {
        if (cache.containsKey(cp)) {
            return cache.get(cp);
        }
        int mask = profile.HIGHWAY_DISTANCE_MASK;
        if (mask <= 0) {
            cache.put(cp, -1);
            return -1;
        }
        if ((cp.getCoord(orientation.getOpposite()) & mask) != 0) {
            cache.put(cp, -1);
            return -1;
        }
        if ((provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && CitySphere.intersectsWithCitySphere(cp.chunkX(), cp.chunkZ(), provider)) {
            cache.put(cp, -1);
            return -1;
        }
        Highway.makePerlin(provider.getSeed());
        if (hasHighway.apply(cp).booleanValue()) {
            ChunkCoord lower = cp.lower(orientation);
            while (hasHighway.apply(lower).booleanValue()) {
                lower = lower.lower(orientation);
            }
            lower = lower.higher(orientation);
            ChunkCoord higher = cp.higher(orientation);
            while (hasHighway.apply(higher).booleanValue()) {
                higher = higher.higher(orientation);
            }
            higher = higher.lower(orientation);
            int level = -1;
            if (higher.getCoord(orientation) - lower.getCoord(orientation) >= 5) {
                boolean valid;
                if (profile.HIGHWAY_REQUIRES_TWO_CITIES) {
                    valid = BuildingInfo.isCityRaw(lower.chunkX(), lower.chunkZ(), provider, profile) && BuildingInfo.isCityRaw(higher.chunkX(), higher.chunkZ(), provider, profile);
                } else {
                    boolean bl = valid = BuildingInfo.isCityRaw(lower.chunkX(), lower.chunkZ(), provider, profile) || BuildingInfo.isCityRaw(higher.chunkX(), higher.chunkZ(), provider, profile);
                }
                if (valid) {
                    level = switch (profile.HIGHWAY_LEVEL_FROM_CITIES_MODE) {
                        case 0 -> BuildingInfo.getCityLevel(lower.chunkX(), lower.chunkZ(), provider);
                        case 1 -> Math.min(BuildingInfo.getCityLevel(lower.chunkX(), lower.chunkZ(), provider), BuildingInfo.getCityLevel(higher.chunkX(), higher.chunkZ(), provider));
                        case 2 -> Math.max(BuildingInfo.getCityLevel(lower.chunkX(), lower.chunkZ(), provider), BuildingInfo.getCityLevel(higher.chunkX(), higher.chunkZ(), provider));
                        case 3 -> (BuildingInfo.getCityLevel(lower.chunkX(), lower.chunkZ(), provider) + BuildingInfo.getCityLevel(higher.chunkX(), higher.chunkZ(), provider)) / 2;
                        default -> throw new RuntimeException("Bad value for 'highwayLevelFromCities'!");
                    };
                    ChunkCoord cc = lower;
                    while (cc.getCoord(orientation) <= higher.getCoord(orientation)) {
                        cache.put(cc, level);
                        cc = cc.higher(orientation);
                    }
                }
            }
            return level;
        }
        cache.put(cp, -1);
        return -1;
    }

    private static boolean hasXHighway(ChunkCoord cp, LostCityProfile profile) {
        return perlinX.getValue((float)cp.chunkX() / profile.HIGHWAY_MAINPERLIN_SCALE, (float)cp.chunkZ() / profile.HIGHWAY_SECONDARYPERLIN_SCALE) > (double)profile.HIGHWAY_PERLIN_FACTOR;
    }

    private static boolean hasZHighway(ChunkCoord cp, LostCityProfile profile) {
        return perlinZ.getValue((float)cp.chunkX() / profile.HIGHWAY_SECONDARYPERLIN_SCALE, (float)cp.chunkZ() / profile.HIGHWAY_MAINPERLIN_SCALE) > (double)profile.HIGHWAY_PERLIN_FACTOR;
    }
}

