/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.GeometryTools;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostTags;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Explosion;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DamageArea {
    public static final float BLOCK_DAMAGE_CHANCE = 0.7f;
    private final long seed;
    private final int chunkX;
    private final int chunkZ;
    private final List<Explosion> explosions = new ArrayList<Explosion>();
    private final AABB chunkBox;
    private final LostCityProfile profile;
    private final BlockState air;

    public DamageArea(int chunkX, int chunkZ, IDimensionInfo provider, BuildingInfo info) {
        this.seed = provider.getSeed();
        this.profile = info.profile;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.air = Blocks.f_50016_.m_49966_();
        this.chunkBox = new AABB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), 256.0, (double)(chunkZ * 16 + 15));
        Random damageRandom = new Random(this.seed + (long)chunkZ * 295075153L + (long)chunkX * 899826547L);
        damageRandom.nextFloat();
        damageRandom.nextFloat();
        int offset = (Math.max(info.profile.EXPLOSION_MAXRADIUS, info.profile.MINI_EXPLOSION_MAXRADIUS) + 15) / 16;
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                Float chance;
                if (info.profile.EXPLOSIONS_IN_CITIES_ONLY && !BuildingInfo.isCity(cx, cz, provider)) continue;
                Explosion explosion = this.getExplosionAt(cx, cz, provider);
                if (explosion != null && this.intersectsWith(explosion.getCenter(), explosion.getRadius()) && ((chance = BuildingInfo.getChunkCharacteristics((int)cx, (int)cz, (IDimensionInfo)provider).cityStyle.getExplosionChance()) == null || damageRandom.nextFloat() < chance.floatValue())) {
                    this.explosions.add(explosion);
                }
                if ((explosion = this.getMiniExplosionAt(cx, cz, provider)) == null || !this.intersectsWith(explosion.getCenter(), explosion.getRadius()) || (chance = BuildingInfo.getChunkCharacteristics((int)cx, (int)cz, (IDimensionInfo)provider).cityStyle.getExplosionChance()) != null && !(damageRandom.nextFloat() < chance.floatValue())) continue;
                this.explosions.add(explosion);
            }
        }
    }

    public BlockState damageBlock(BlockState b, IDimensionInfo provider, int y, float damage, CompiledPalette palette, BlockState liquidChar) {
        if (Tools.hasTag(b.m_60734_(), LostTags.NOT_BREAKABLE_TAG)) {
            return b;
        }
        if (Tools.hasTag(b.m_60734_(), LostTags.EASY_BREAKABLE_TAG)) {
            damage *= 2.5f;
        }
        if (provider.getRandom().nextFloat() <= damage) {
            BlockState damaged = palette.canBeDamagedToIronBars(b);
            int waterlevel = Tools.getSeaLevel((LevelReader)provider.getWorld());
            b = damage < 0.7f && damaged != null ? (provider.getRandom().nextFloat() < 0.7f ? damaged : (y <= waterlevel ? liquidChar : this.air)) : (y <= waterlevel ? liquidChar : this.air);
        }
        return b;
    }

    private boolean intersectsWith(BlockPos center, int radius) {
        double dmin = GeometryTools.squaredDistanceBoxPoint(this.chunkBox, center);
        return dmin <= (double)(radius * radius);
    }

    private Explosion getExplosionAt(int chunkX, int chunkZ, IDimensionInfo provider) {
        Random randomExplosion = new Random(this.seed + (long)chunkZ * 295075153L + (long)chunkX * 797003437L);
        randomExplosion.nextFloat();
        randomExplosion.nextFloat();
        if (randomExplosion.nextFloat() < this.profile.EXPLOSION_CHANCE) {
            return new Explosion(this.profile.EXPLOSION_MINRADIUS + randomExplosion.nextInt(this.profile.EXPLOSION_MAXRADIUS - this.profile.EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + randomExplosion.nextInt(16), BuildingInfo.getBuildingInfo((int)chunkX, (int)chunkZ, (IDimensionInfo)provider).cityLevel * 6 + this.profile.EXPLOSION_MINHEIGHT + randomExplosion.nextInt(this.profile.EXPLOSION_MAXHEIGHT - this.profile.EXPLOSION_MINHEIGHT), chunkZ * 16 + randomExplosion.nextInt(16)));
        }
        return null;
    }

    private Explosion getMiniExplosionAt(int chunkX, int chunkZ, IDimensionInfo provider) {
        Random randomMiniExplosion = new Random(this.seed + (long)chunkZ * 1400305337L + (long)chunkX * 573259391L);
        randomMiniExplosion.nextFloat();
        randomMiniExplosion.nextFloat();
        if (randomMiniExplosion.nextFloat() < this.profile.MINI_EXPLOSION_CHANCE) {
            return new Explosion(this.profile.MINI_EXPLOSION_MINRADIUS + randomMiniExplosion.nextInt(this.profile.MINI_EXPLOSION_MAXRADIUS - this.profile.MINI_EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + randomMiniExplosion.nextInt(16), BuildingInfo.getBuildingInfo((int)chunkX, (int)chunkZ, (IDimensionInfo)provider).cityLevel * 6 + this.profile.MINI_EXPLOSION_MINHEIGHT + randomMiniExplosion.nextInt(this.profile.MINI_EXPLOSION_MAXHEIGHT - this.profile.MINI_EXPLOSION_MINHEIGHT), chunkZ * 16 + randomMiniExplosion.nextInt(16)));
        }
        return null;
    }

    public boolean hasExplosions() {
        return !this.explosions.isEmpty();
    }

    public List<Explosion> getExplosions() {
        return this.explosions;
    }

    public boolean hasExplosions(int y) {
        AABB box = new AABB((double)(this.chunkX * 16), (double)(y * 16), (double)(this.chunkZ * 16), (double)(this.chunkX * 16 + 15), (double)(y * 16 + 15), (double)(this.chunkZ * 16 + 15));
        for (Explosion explosion : this.explosions) {
            double dmin = GeometryTools.squaredDistanceBoxPoint(box, explosion.getCenter());
            if (!(dmin <= (double)(explosion.getRadius() * explosion.getRadius()))) continue;
            return true;
        }
        return false;
    }

    public boolean isCompletelyDestroyed(int y) {
        AABB box = new AABB((double)(this.chunkX * 16), (double)(y * 16), (double)(this.chunkZ * 16), (double)(this.chunkX * 16 + 15), (double)(y * 16 + 15), (double)(this.chunkZ * 16 + 15));
        for (Explosion explosion : this.explosions) {
            int sqdist;
            double dmax = GeometryTools.maxSquaredDistanceBoxPoint(box, explosion.getCenter());
            if (!(dmax <= (double)(sqdist = explosion.getRadius() * explosion.getRadius()))) continue;
            double dist = ((double)explosion.getRadius() - 3.0 * (double)explosion.getRadius()) / -3.0;
            if (!(dmax <= (dist *= dist))) continue;
            return true;
        }
        return false;
    }

    public int getLowestExplosionHeight() {
        for (int yy = 0; yy < 16; ++yy) {
            if (!this.hasExplosions(yy)) continue;
            return yy * 16;
        }
        return -1;
    }

    public int getHighestExplosionHeight() {
        for (int yy = 15; yy >= 0; --yy) {
            if (!this.hasExplosions(yy)) continue;
            return yy * 16 + 15;
        }
        return -1;
    }

    public float getDamageFactor() {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().m_203198_((double)this.chunkX * 16.0, (double)explosion.getCenter().m_123342_(), (double)this.chunkZ * 16.0);
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }

    public float getDamage(int x, int y, int z) {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().m_203198_((double)x, (double)y, (double)z);
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }
}

