/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CityRarityMap;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedStreet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import org.apache.commons.lang3.tuple.Pair;

public class City {
    private static Map<ChunkCoord, PredefinedCity> predefinedCityMap = null;
    private static Map<ChunkCoord, PredefinedBuilding> predefinedBuildingMap = null;
    private static Map<ChunkCoord, PredefinedStreet> predefinedStreetMap = null;
    private static final Map<ResourceKey<Level>, CityRarityMap> CITY_RARITY_MAP = new HashMap<ResourceKey<Level>, CityRarityMap>();

    public static void cleanCache() {
        predefinedCityMap = null;
        predefinedBuildingMap = null;
        predefinedStreetMap = null;
        CITY_RARITY_MAP.clear();
    }

    public static CityRarityMap getCityRarityMap(ResourceKey<Level> level, long seed, double scale, double offset, double innerScale) {
        return CITY_RARITY_MAP.computeIfAbsent(level, k -> new CityRarityMap(seed, scale, offset, innerScale));
    }

    public static PredefinedCity getPredefinedCity(int chunkX, int chunkZ, ResourceKey<Level> type) {
        if (predefinedCityMap == null) {
            predefinedCityMap = new HashMap<ChunkCoord, PredefinedCity>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                predefinedCityMap.put(new ChunkCoord(city.getDimension(), city.getChunkX(), city.getChunkZ()), city);
            }
        }
        if (predefinedCityMap.isEmpty()) {
            return null;
        }
        return predefinedCityMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static PredefinedBuilding getPredefinedBuilding(int chunkX, int chunkZ, ResourceKey<Level> type) {
        if (predefinedBuildingMap == null) {
            predefinedBuildingMap = new HashMap<ChunkCoord, PredefinedBuilding>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedBuilding building : city.getPredefinedBuildings()) {
                    predefinedBuildingMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + building.relChunkX(), city.getChunkZ() + building.relChunkZ()), building);
                }
            }
        }
        if (predefinedBuildingMap.isEmpty()) {
            return null;
        }
        return predefinedBuildingMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static PredefinedStreet getPredefinedStreet(int chunkX, int chunkZ, ResourceKey<Level> type) {
        if (predefinedStreetMap == null) {
            predefinedStreetMap = new HashMap<ChunkCoord, PredefinedStreet>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedStreet street : city.getPredefinedStreets()) {
                    predefinedStreetMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + street.relChunkX(), city.getChunkZ() + street.relChunkZ()), street);
                }
            }
        }
        if (predefinedStreetMap.isEmpty()) {
            return null;
        }
        return predefinedStreetMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static boolean isCityCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null) {
            return true;
        }
        Random cityCenterRandom = new Random((long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        cityCenterRandom.nextFloat();
        cityCenterRandom.nextFloat();
        if (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) {
            CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
            if (!sphere.isEnabled()) {
                return cityCenterRandom.nextDouble() < provider.getOutsideProfile().CITY_CHANCE;
            }
            if (sphere.getCenter().chunkX() == chunkX && sphere.getCenter().chunkZ() == chunkZ) {
                return cityCenterRandom.nextDouble() < provider.getProfile().CITY_CHANCE;
            }
            return false;
        }
        return cityCenterRandom.nextDouble() < provider.getProfile().CITY_CHANCE;
    }

    public static float getCityRadius(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null) {
            return city.getRadius();
        }
        Random cityRadiusRandom = new Random((long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        cityRadiusRandom.nextFloat();
        cityRadiusRandom.nextFloat();
        LostCityProfile profile = provider.getProfile();
        int cityRange = profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS;
        if (cityRange < 1) {
            cityRange = 1;
        }
        if (profile.isSpace() || profile.isSpheres()) {
            if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                return profile.CITY_MINRADIUS + cityRadiusRandom.nextInt(cityRange);
            }
            return provider.getOutsideProfile().CITY_MINRADIUS + cityRadiusRandom.nextInt(provider.getOutsideProfile().CITY_MAXRADIUS - provider.getOutsideProfile().CITY_MINRADIUS);
        }
        return profile.CITY_MINRADIUS + cityRadiusRandom.nextInt(cityRange);
    }

    public static String getCityStyleForCityCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null && city.getCityStyle() != null) {
            return city.getCityStyle();
        }
        Random cityStyleForCenterRandom = new Random((long)chunkZ * 899809363L + (long)chunkX * 256203221L);
        cityStyleForCenterRandom.nextFloat();
        cityStyleForCenterRandom.nextFloat();
        return provider.getWorldStyle().getRandomCityStyle(provider, chunkX, chunkZ, cityStyleForCenterRandom);
    }

    public static CityStyle getCityStyle(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        Pair fromList;
        ArrayList<Pair> styles = new ArrayList<Pair>();
        Random cityStyleRandom = new Random(provider.getSeed() + (long)chunkZ * 593441843L + (long)chunkX * 217645177L);
        cityStyleRandom.nextFloat();
        cityStyleRandom.nextFloat();
        if (profile.CITY_CHANCE < 0.0) {
            WorldGenLevel world = provider.getWorld();
            CityRarityMap rarityMap = City.getCityRarityMap((ResourceKey<Level>)world.m_6018_().m_46472_(), world.m_7328_(), profile.CITY_PERLIN_SCALE, profile.CITY_PERLIN_OFFSET, profile.CITY_PERLIN_INNERSCALE);
            float factor = rarityMap.getCityFactor(chunkX, chunkZ);
            if (factor < profile.CITY_STYLE_THRESHOLD) {
                styles.add(Pair.of((Object)Float.valueOf(factor), (Object)profile.CITY_STYLE_ALTERNATIVE));
            } else {
                styles.add(Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(chunkX, chunkZ, provider)));
            }
        } else {
            int offset = (profile.CITY_MAXRADIUS + 15) / 16;
            for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
                for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                    float radius;
                    float sqdist;
                    if (!City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                    float dist = (float)Math.sqrt(sqdist);
                    float factor = (radius - dist) / radius;
                    if (factor < profile.CITY_STYLE_THRESHOLD) {
                        styles.add(Pair.of((Object)Float.valueOf(factor), (Object)profile.CITY_STYLE_ALTERNATIVE));
                        continue;
                    }
                    styles.add(Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(chunkX, chunkZ, provider)));
                }
            }
        }
        Object cityStyleName = styles.isEmpty() ? provider.getWorldStyle().getRandomCityStyle(provider, chunkX, chunkZ, cityStyleRandom) : ((fromList = Tools.getRandomFromList(cityStyleRandom, styles, Pair::getLeft)) == null ? null : (String)fromList.getRight());
        return AssetRegistries.CITYSTYLES.get((CommonLevelAccessor)provider.getWorld(), (String)cityStyleName);
    }

    public static float getCityFactor(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        ResourceKey<Level> type = provider.getType();
        PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
        if (predefinedBuilding != null) {
            return 1.0f;
        }
        PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, type);
        if (predefinedStreet != null) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ, type);
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ - 1, type);
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ - 1, type);
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return 1.0f;
        }
        float factor = 0.0f;
        if (profile.CITY_CHANCE < 0.0) {
            CityRarityMap rarityMap = City.getCityRarityMap(provider.dimension(), provider.getSeed(), profile.CITY_PERLIN_SCALE, profile.CITY_PERLIN_OFFSET, profile.CITY_PERLIN_INNERSCALE);
            factor = rarityMap.getCityFactor(chunkX, chunkZ);
        } else {
            int offset = (profile.CITY_MAXRADIUS + 15) / 16;
            for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
                for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                    float radius;
                    float sqdist;
                    LostCityProfile pro = BuildingInfo.getProfile(cx, cz, provider);
                    if (pro != profile || !City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                    float dist = (float)Math.sqrt(sqdist);
                    factor += (radius - dist) / radius;
                }
            }
        }
        if ((double)factor > 1.0E-4 && provider.getWorld() != null) {
            WorldStyle worldStyle = AssetRegistries.WORLDSTYLES.get((CommonLevelAccessor)provider.getWorld(), profile.getWorldStyle());
            float multiplier = worldStyle.getCityChanceMultiplier(provider, chunkX, chunkZ);
            factor *= multiplier;
        }
        return Math.min(Math.max(factor, 0.0f), 1.0f);
    }
}

