/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mcjty.lostcities.editor.EditorInfo;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.regassets.BuildingPartRE;
import mcjty.lostcities.worldgen.lost.regassets.PaletteRE;
import mcjty.lostcities.worldgen.lost.regassets.data.PaletteEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class CommandExportPart
implements Command<CommandSourceStack> {
    private static final CommandExportPart CMD = new CommandExportPart();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"exportpart").requires(cs -> cs.m_6761_(1))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String filename = (String)context.getArgument("name", String.class);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        EditorInfo editorInfo = EditorInfo.getEditorInfo(player.m_20148_());
        if (editorInfo == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not editing anything!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        BuildingPart part = AssetRegistries.PARTS.get((CommonLevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), editorInfo.getPartName());
        if (part == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error finding part '" + editorInfo.getPartName() + "'!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        BlockPos start = editorInfo.getBottomLocation();
        ServerLevel level = (ServerLevel)player.m_9236_();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        BuildingInfo info = BuildingInfo.getBuildingInfo(start.m_123341_() >> 4, start.m_123343_() >> 4, dimInfo);
        CompiledPalette palette = info.getCompiledPalette();
        Palette partPalette = part.getLocalPalette((CommonLevelAccessor)level);
        Palette buildingPalette = info.getBuilding().getLocalPalette((CommonLevelAccessor)level);
        if (partPalette != null || buildingPalette != null) {
            palette = new CompiledPalette(palette, partPalette, buildingPalette);
        }
        HashMap<BlockState, Character> unknowns = new HashMap<BlockState, Character>();
        ArrayList<List<String>> slices = new ArrayList<List<String>>();
        HashSet<Character> usedCharacters = new HashSet<Character>(palette.getCharacters());
        String possibleChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-=[]{}|;:'<>,.?/`~";
        for (int y = 0; y < part.getSliceCount(); ++y) {
            ArrayList<String> yslice = new ArrayList<String>();
            for (int z = 0; z < part.getZSize(); ++z) {
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < part.getXSize(); ++i) {
                    BlockPos pos = new BlockPos(info.chunkX * 16 + i, start.m_123342_() + y, info.chunkZ * 16 + z);
                    BlockState state = level.m_8055_(pos);
                    Character c = editorInfo.getPaleteEntry(state);
                    if (c == null) {
                        c = (Character)unknowns.get(state);
                    }
                    if (c == null) {
                        c = Character.valueOf((char)possibleChars.chars().filter(value -> !usedCharacters.contains(Character.valueOf((char)value))).findFirst().getAsInt());
                        unknowns.put(state, c);
                        usedCharacters.add(c);
                    }
                    b.append(c);
                }
                yslice.add(b.toString());
            }
            slices.add(yslice);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject root = new JsonObject();
        if (!unknowns.isEmpty()) {
            ArrayList<PaletteEntry> entries = new ArrayList<PaletteEntry>();
            for (Map.Entry entry : unknowns.entrySet()) {
                entries.add(new PaletteEntry(Character.toString(((Character)entry.getValue()).charValue()), Optional.of(Tools.stateToString((BlockState)entry.getKey())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
            }
            PaletteRE paletteRE = new PaletteRE(entries);
            DataResult dataResult = PaletteRE.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)paletteRE);
            root.add("__comment__", (JsonElement)new JsonPrimitive("'missingpalette' represents all blockstates that it couldn't find in the palette. These have to be put in a palette. 'exportedpart' is the actual exported part"));
            root.add("missingpalette", (JsonElement)dataResult.result().get());
        } else {
            root.add("__comment__", (JsonElement)new JsonPrimitive("'exportedpart' is the actual exported part"));
        }
        BuildingPartRE buildingPartRE = new BuildingPartRE(part.getXSize(), part.getZSize(), slices, Optional.ofNullable(part.getRefPaletteName()), Optional.empty(), Optional.empty());
        DataResult result = BuildingPartRE.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)buildingPartRE);
        root.add("exportedpart", (JsonElement)result.result().get());
        String string = gson.toJson((JsonElement)root);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write(string);
            writer.close();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentFactory.literal("Exported part to '" + filename + "'!"), false);
        }
        catch (IOException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error writing file '" + filename + "'!")).m_130940_(ChatFormatting.RED));
        }
        return 0;
    }
}

