/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.client.render;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.registry.LCItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class SentryShieldRenderer
implements ICurioRenderer {
    private static final ResourceLocation TEXTURE = SentryShieldRenderer.tex(0);
    private static final ResourceLocation TEXTURE_SLIM = SentryShieldRenderer.tex(1);
    private static final ResourceLocation TEXTURE_EMIS = SentryShieldRenderer.tex(2);
    private final HumanoidModel<LivingEntity> shieldModel;
    private final PlayerModel<LivingEntity> shieldModelSlim;
    public final HumanoidModel<LivingEntity> shieldModelArm;
    public final PlayerModel<LivingEntity> dummyArm;
    public final PlayerModel<LivingEntity> dummyArmSlim;

    public SentryShieldRenderer() {
        EntityModelSet models = Minecraft.m_91087_().m_167973_();
        this.shieldModel = new HumanoidModel(models.m_171103_(AetherModelLayers.SHIELD_OF_REPULSION));
        this.shieldModelSlim = new PlayerModel(models.m_171103_(AetherModelLayers.SHIELD_OF_REPULSION_SLIM), true);
        this.shieldModelArm = new HumanoidModel(models.m_171103_(AetherModelLayers.SHIELD_OF_REPULSION_ARM));
        this.dummyArm = new PlayerModel(models.m_171103_(ModelLayers.f_171162_), false);
        this.dummyArmSlim = new PlayerModel(models.m_171103_(ModelLayers.f_171166_), true);
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, LCItems.sentry_shield).ifPresent(slotResult -> CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getStacksHandler(slotResult.slotContext().identifier()).ifPresent(stacksHandler -> {
            if (((Boolean)stacksHandler.getRenders().get(slotResult.slotContext().index())).booleanValue()) {
                ResourceLocation texture = TEXTURE;
                HumanoidModel<LivingEntity> model = this.shieldModel;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    EntityModel patt3607$temp = renderLayerParent.m_7200_();
                    if (patt3607$temp instanceof PlayerModel) {
                        PlayerModel playerModel = (PlayerModel)patt3607$temp;
                        if (playerModel.f_103380_) {
                            texture = TEXTURE_SLIM;
                            model = this.shieldModelSlim;
                        }
                    }
                }
                ICurioRenderer.followHeadRotations((LivingEntity)slotContext.entity(), (ModelPart[])new ModelPart[]{model.f_102808_});
                ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
                VertexConsumer consumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110473_((ResourceLocation)texture), (boolean)false, (boolean)false);
                model.m_7695_(poseStack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                model.m_7695_(poseStack, ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110488_((ResourceLocation)TEXTURE_EMIS), (boolean)false, (boolean)false), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        })));
    }

    public void renderFirstPerson(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, HumanoidArm arm) {
        boolean isSlim = player.m_108564_().equals("slim");
        this.setupHand(this.dummyArm, poseStack, buffer, combinedLight, player, arm);
        this.setupShield(stack, this.shieldModelArm, poseStack, buffer, combinedLight, player, arm, isSlim);
    }

    private void setupShield(ItemStack stack, HumanoidModel<LivingEntity> model, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, HumanoidArm arm, boolean isSlim) {
        this.setupModel(model, player);
        this.renderShield(arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_, poseStack, combinedLight, ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110473_((ResourceLocation)(isSlim ? TEXTURE_SLIM : TEXTURE)), (boolean)false, (boolean)stack.m_41793_()));
    }

    private void setupHand(PlayerModel<LivingEntity> model, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, HumanoidArm arm) {
        this.setupModel((HumanoidModel<LivingEntity>)model, player);
        this.renderHand(arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_, model.f_103375_, poseStack, combinedLight, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)player.m_108560_())));
    }

    private void setupModel(HumanoidModel<LivingEntity> model, AbstractClientPlayer player) {
        model.m_8009_(false);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void renderShield(ModelPart shieldArm, PoseStack poseStack, int combinedLight, VertexConsumer consumer) {
        shieldArm.f_104207_ = true;
        shieldArm.f_104203_ = 0.0f;
        shieldArm.m_104306_(poseStack, consumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderHand(ModelPart dummyArm, ModelPart dummySleeve, PoseStack poseStack, int combinedLight, VertexConsumer consumer) {
        dummyArm.f_104207_ = true;
        dummySleeve.f_104207_ = true;
        dummyArm.f_104203_ = 0.0f;
        dummySleeve.f_104203_ = 0.0f;
        dummyArm.m_104306_(poseStack, consumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        dummySleeve.m_104306_(poseStack, consumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static ResourceLocation tex(int type) {
        return LostContentMod.locate("textures/models/accessory/sentry_shield/sentry_shield_" + (type == 1 ? "slim_" : "") + "accessory" + (type == 2 ? "_glow" : "") + ".png");
    }
}

