/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.init.ModLoot;

public class LootCount
implements LootItemCondition {
    private final List<Operation> operations;

    public LootCount(List<Operation> operations) {
        this.operations = operations;
    }

    public LootItemConditionType m_7940_() {
        return ModLoot.LOOT_COUNT;
    }

    public boolean test(LootContext lootContext) {
        Vec3 incomingPos = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        if (incomingPos == null) {
            return false;
        }
        BlockPos position = new BlockPos((int)incomingPos.f_82479_, (int)incomingPos.f_82480_, (int)incomingPos.f_82481_);
        BlockEntity tileentity = lootContext.m_78952_().m_7702_(position);
        if (tileentity instanceof ILootBlockEntity) {
            int count = ((ILootBlockEntity)tileentity).getOpeners().size() + 1;
            for (Operation op : this.operations) {
                if (op.test(count)) continue;
                return false;
            }
        }
        return true;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public static class Operation
    implements Predicate<Integer> {
        private final Operand operand;
        private final int value;

        public Operation(Operand operand, int value) {
            this.operand = operand;
            this.value = value;
        }

        public int getPrecedence() {
            return this.operand.getPrecedence();
        }

        @Override
        public boolean test(Integer integer) {
            return this.operand.test(integer, this.value);
        }

        public JsonObject serialize() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.operand.name().toLowerCase(Locale.ROOT));
            result.addProperty("value", (Number)this.value);
            return result;
        }

        public static Operation deserialize(JsonObject object) {
            String operand = object.get("type").getAsString();
            Operand op = Operand.fromString(operand);
            if (op == null) {
                throw new IllegalArgumentException("invalid operand for operation: " + operand);
            }
            return new Operation(op, object.get("value").getAsInt());
        }
    }

    public static enum Operand implements BiPredicate<Integer, Integer>
    {
        EQUALS(Integer::equals, 0),
        NOT_EQUALS((a, b) -> !a.equals(b), 0),
        LESS_THAN((a, b) -> a < b, 1),
        GREATER_THAN((a, b) -> a > b, 1),
        LESS_THAN_EQUALS((a, b) -> a <= b, 1),
        GREATER_THAN_EQUALS((a, b) -> a >= b, 1);

        private final BiPredicate<Integer, Integer> predicate;
        private final int precedence;

        private Operand(BiPredicate<Integer, Integer> predicate, int precedence) {
            this.predicate = predicate;
            this.precedence = precedence;
        }

        @Override
        public boolean test(Integer integer, Integer integer2) {
            return this.predicate.test(integer, integer2);
        }

        public int getPrecedence() {
            return this.precedence;
        }

        @Nullable
        public static Operand fromString(String name) {
            name = name.toUpperCase(Locale.ROOT);
            for (Operand o : Operand.values()) {
                if (!name.equals(o.name())) continue;
                return o;
            }
            return null;
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootCount> {
        public void serialize(JsonObject object, LootCount count, JsonSerializationContext context) {
            JsonArray operations = new JsonArray();
            for (Operation op : count.operations) {
                operations.add((JsonElement)op.serialize());
            }
            object.add("operations", (JsonElement)operations);
        }

        public LootCount deserialize(JsonObject object, JsonDeserializationContext context) {
            JsonArray objects = object.get("operations").getAsJsonArray();
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (JsonElement element : objects) {
                if (!element.isJsonObject()) {
                    throw new IllegalArgumentException("invalid operand for LootCount: " + element.toString());
                }
                operations.add(Operation.deserialize(element.getAsJsonObject()));
            }
            operations.sort(Comparator.comparingInt(Operation::getPrecedence));
            return new LootCount(operations);
        }
    }
}

