/*
 * Decompiled with CFR 0.152.
 */
package com.logprot.players;

import com.logprot.Logprot;
import com.logprot.Utils.BlockPosUtils;
import com.logprot.config.CommonConfiguration;
import com.logprot.event.PlayerEventHandler;
import com.logprot.players.PlayerData;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

public class PlayerManager {
    private static PlayerManager instance;
    private WeakHashMap<UUID, PlayerData> playerDataMap = new WeakHashMap();

    private PlayerManager() {
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
            ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register((Object)PlayerEventHandler.getInstance());
        }
        return instance;
    }

    public void onPlayerLogin(Player player) {
        if (this.playerDataMap.containsKey(player.m_20148_())) {
            return;
        }
        this.playerDataMap.put(player.m_20148_(), new PlayerData(player, player.m_20183_(), System.currentTimeMillis() + (long)(((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime / 20) * 1000L));
        if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Player:" + player.m_5446_().getString() + " now has protection for " + ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime + " ticks");
        }
    }

    public void updatePlayers() {
        if (this.playerDataMap.isEmpty()) {
            return;
        }
        double maxDist = Math.pow(((CommonConfiguration)Logprot.config.getCommonConfig()).maxDist, 2.0);
        Iterator<Map.Entry<UUID, PlayerData>> iterator = this.playerDataMap.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            if (!entry.getValue().player.m_6084_()) {
                iterator.remove();
                break;
            }
            if ((double)BlockPosUtils.dist2DSQ(entry.getValue().loginPos, entry.getValue().player.m_20183_()) > maxDist) {
                if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
                    Logprot.LOGGER.info("Player:" + entry.getValue().player.m_7755_().getString() + " got his login protection removed due to moving");
                }
                entry.getValue().player.f_20916_ = 0;
                iterator.remove();
                break;
            }
            if (entry.getValue().invulTimePoint > currentTime) continue;
            if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
                Logprot.LOGGER.info("Player:" + entry.getValue().player.m_7755_().getString() + " got his login protection removed due to timeout");
            }
            entry.getValue().player.f_20916_ = 0;
            iterator.remove();
        }
    }

    public boolean isPlayerImmune(Player playerEntity) {
        this.updatePlayers();
        return this.playerDataMap.containsKey(playerEntity.m_20148_());
    }

    public void onPlayerTeleport(ServerPlayer player) {
        this.playerDataMap.put(player.m_20148_(), new PlayerData((Player)player, new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_()), ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime));
        if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Teleported player:" + player.m_7755_().getString() + " now has login protection for " + ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime + " ticks");
        }
    }
}

