/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawGenerator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class AlternateJigsawStructure
extends Structure {
    public static final Codec<AlternateJigsawStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)AlternateJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(AlternateJigsawStructure::startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(AlternateJigsawStructure::startJigsawName), (App)IntProvider.m_146545_((int)0, (int)20).fieldOf("size").forGetter(AlternateJigsawStructure::size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(AlternateJigsawStructure::startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(AlternateJigsawStructure::useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(AlternateJigsawStructure::projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(AlternateJigsawStructure::maxDistanceFromCenter)).apply((Applicative)instance, AlternateJigsawStructure::new)), AlternateJigsawStructure::validate).codec();
    public static final StructureType<AlternateJigsawStructure> ALTERNATE_JIGSAW_TYPE = () -> CODEC;
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final IntProvider size;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<AlternateJigsawStructure> validate(AlternateJigsawStructure structure) {
        int i = switch (structure.m_226620_()) {
            default -> throw new IncompatibleClassChangeError();
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
        };
        return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    protected AlternateJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, IntProvider size, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Holder<StructureTemplatePool> startPool() {
        return this.startPool;
    }

    public Optional<ResourceLocation> startJigsawName() {
        return this.startJigsawName;
    }

    public IntProvider size() {
        return this.size;
    }

    public HeightProvider startHeight() {
        return this.startHeight;
    }

    public boolean useExpansionHack() {
        return this.useExpansionHack;
    }

    public Optional<Heightmap.Types> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public int maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), i, chunkPos.m_45605_());
        return AlternateJigsawGenerator.generate(context, this.startPool, this.startJigsawName, this.size.m_214085_((RandomSource)context.f_226626_()), blockPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return ALTERNATE_JIGSAW_TYPE;
    }
}

