/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.serialization.Codec;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedForgeBiomeModifiers;
import dev.worldgen.lithostitched.registry.LithostitchedRegistries;
import dev.worldgen.lithostitched.worldgen.modifier.AddBiomeSpawnsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.AddFeaturesModifier;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.RemoveBiomeSpawnsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.RemoveFeaturesModifier;
import dev.worldgen.lithostitched.worldgen.modifier.ReplaceClimateModifier;
import dev.worldgen.lithostitched.worldgen.modifier.ReplaceEffectsModifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.surface.LithostitchedSurfaceRules;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public final class LithostitchedBuiltInRegistries {
    private static final DeferredRegister<Codec<? extends Modifier>> DEFERRED_MODIFIER_TYPES = DeferredRegister.create(LithostitchedRegistries.MODIFIER_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<Codec<? extends Modifier>>> MODIFIER_TYPE = DEFERRED_MODIFIER_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<Codec<? extends ModifierPredicate>> DEFERRED_MODIFIER_PREDICATES_TYPES = DeferredRegister.create(LithostitchedRegistries.MODIFIER_PREDICATE_TYPE, (String)"lithostitched");
    public static final Supplier<IForgeRegistry<Codec<? extends ModifierPredicate>>> MODIFIER_PREDICATE_TYPE = DEFERRED_MODIFIER_PREDICATES_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags().disableSync().disableSaving());
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"lithostitched");

    public static void init(IEventBus bus) {
        bus.addListener(event -> {
            event.register(Registries.f_256815_, helper -> helper.register("transient_merged", (Object)LithostitchedSurfaceRules.TransientMergedRuleSource.CODEC.f_216232_()));
            LithostitchedCommon.registerCommonFeatureTypes((name, feature) -> event.register(Registries.f_256833_, helper -> helper.register(name, feature)));
            LithostitchedCommon.registerCommonPoolElementTypes((name, codec) -> event.register(Registries.f_257024_, helper -> helper.register(name, () -> codec)));
            LithostitchedCommon.registerCommonStructureTypes((name, codec) -> event.register(Registries.f_256938_, helper -> helper.register(name, () -> codec)));
            LithostitchedCommon.registerCommonStructureProcessors((name, codec) -> event.register(Registries.f_256983_, helper -> helper.register(name, () -> codec)));
            LithostitchedCommon.registerCommonBlockEntityModifiers((name, codec) -> event.register(Registries.f_276428_, helper -> helper.register(name, () -> codec)));
        });
        bus.addListener(event -> event.dataPackRegistry(LithostitchedRegistries.WORLDGEN_MODIFIER, Modifier.CODEC));
        LithostitchedBuiltInRegistries.registerForgeBiomeModifiers((name, codec) -> BIOME_MODIFIER_SERIALIZERS.register(name, () -> codec));
        BIOME_MODIFIER_SERIALIZERS.register(bus);
        LithostitchedCommon.registerCommonModifiers((name, codec) -> DEFERRED_MODIFIER_TYPES.register(name, () -> codec));
        LithostitchedBuiltInRegistries.registerForgeModifiers((name, codec) -> DEFERRED_MODIFIER_TYPES.register(name, () -> codec));
        DEFERRED_MODIFIER_TYPES.register(bus);
        LithostitchedCommon.registerCommonModifierPredicates((name, codec) -> DEFERRED_MODIFIER_PREDICATES_TYPES.register(name, () -> codec));
        DEFERRED_MODIFIER_PREDICATES_TYPES.register(bus);
    }

    public static void registerForgeModifiers(BiConsumer<String, Codec<? extends Modifier>> consumer) {
        consumer.accept("add_biome_spawns", AddBiomeSpawnsModifier.CODEC);
        consumer.accept("add_features", AddFeaturesModifier.CODEC);
        consumer.accept("remove_biome_spawns", RemoveBiomeSpawnsModifier.CODEC);
        consumer.accept("remove_features", RemoveFeaturesModifier.CODEC);
        consumer.accept("replace_climate", ReplaceClimateModifier.CODEC);
        consumer.accept("replace_effects", ReplaceEffectsModifier.CODEC);
    }

    public static void registerForgeBiomeModifiers(BiConsumer<String, Codec<? extends BiomeModifier>> consumer) {
        consumer.accept("replace_climate", LithostitchedForgeBiomeModifiers.ReplaceClimateBiomeModifier.CODEC);
        consumer.accept("replace_effects", LithostitchedForgeBiomeModifiers.ReplaceEffectsBiomeModifier.CODEC);
    }
}

