/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.util.FluidStackKey;
import com.direwolf20.laserio.util.ItemStackKey;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BaseCardCache {
    public final Direction direction;
    public final ItemStack cardItem;
    public final byte channel;
    public final byte redstoneMode;
    public final byte redstoneChannel;
    public final ItemStack filterCard;
    public final int cardSlot;
    public final List<ItemStack> filteredItems;
    public final List<FluidStack> filteredFluids;
    public final List<String> filterTags;
    public final List<String> filterNBTs;
    public final byte sneaky;
    public final LaserNodeBE be;
    public final BaseCard.CardType cardType;
    public int extractLimit = 0;
    public int insertLimit = 0;
    public boolean enabled = true;
    public final boolean isAllowList;
    public final boolean isCompareNBT;
    public final Map<ItemStackKey, Boolean> filterCache = new Object2BooleanOpenHashMap();
    public final Map<ItemStackKey, Integer> filterCounts = new Object2IntOpenHashMap();
    public final Map<FluidStackKey, Boolean> filterCacheFluid = new Object2BooleanOpenHashMap();
    public final Map<FluidStackKey, Integer> filterCountsFluid = new Object2IntOpenHashMap();

    public BaseCardCache(Direction direction, ItemStack cardItem, int cardSlot, LaserNodeBE be) {
        this.cardItem = cardItem;
        this.direction = direction;
        this.sneaky = BaseCard.getSneaky(cardItem);
        this.channel = BaseCard.getChannel(cardItem);
        this.redstoneMode = BaseCard.getRedstoneMode(cardItem);
        this.redstoneChannel = BaseCard.getRedstoneChannel(cardItem);
        this.filterCard = BaseCard.getFilter(cardItem);
        this.cardSlot = cardSlot;
        if (cardItem.m_41720_() instanceof CardItem) {
            this.cardType = BaseCard.CardType.ITEM;
        } else if (cardItem.m_41720_() instanceof CardFluid) {
            this.cardType = BaseCard.CardType.FLUID;
        } else if (cardItem.m_41720_() instanceof CardEnergy) {
            this.cardType = BaseCard.CardType.ENERGY;
            this.insertLimit = CardEnergy.getInsertLimitPercent(cardItem);
            this.extractLimit = CardEnergy.getExtractLimitPercent(cardItem);
        } else {
            this.cardType = cardItem.m_41720_() instanceof CardEnergy ? BaseCard.CardType.REDSTONE : BaseCard.CardType.MISSING;
        }
        this.be = be;
        if (this.filterCard.equals(ItemStack.f_41583_)) {
            this.filteredItems = new ArrayList<ItemStack>();
            this.filteredFluids = new ArrayList<FluidStack>();
            this.filterTags = new ArrayList<String>();
            this.filterNBTs = new ArrayList<String>();
            this.isAllowList = false;
            this.isCompareNBT = false;
        } else {
            this.filteredItems = this.getFilteredItems();
            this.filteredFluids = this.getFilteredFluids();
            this.filterTags = this.getFilterTags();
            this.filterNBTs = this.getFilterNBTs();
            this.isAllowList = BaseFilter.getAllowList(this.filterCard);
            this.isCompareNBT = BaseFilter.getCompareNBT(this.filterCard);
        }
        this.setEnabled();
    }

    public void setEnabled() {
        byte strength;
        this.enabled = this.redstoneMode == 0 || BaseCard.getNamedTransferMode(this.cardItem).equals((Object)BaseCard.TransferMode.SENSOR) ? true : ((strength = this.be.getRedstoneChannelStrength(this.redstoneChannel)) > 0 && this.redstoneMode == 1 ? false : strength != 0 || this.redstoneMode != 2);
    }

    public int getFilterAmt(ItemStack testStack) {
        if (this.filterCard.equals(ItemStack.f_41583_)) {
            return 0;
        }
        if (!(this.filterCard.m_41720_() instanceof FilterCount)) {
            return -1;
        }
        ItemStackKey key = new ItemStackKey(testStack, this.isCompareNBT);
        if (this.filterCounts.containsKey(key)) {
            return this.filterCounts.get(key);
        }
        for (ItemStack stack : this.filteredItems) {
            if (!key.equals(new ItemStackKey(stack, this.isCompareNBT))) continue;
            this.filterCounts.put(key, stack.m_41613_());
            return stack.m_41613_();
        }
        this.filterCounts.put(key, 0);
        return 0;
    }

    public int getFilterAmt(FluidStack testStack) {
        if (this.filterCard.equals(ItemStack.f_41583_)) {
            return 0;
        }
        if (!(this.filterCard.m_41720_() instanceof FilterCount)) {
            return -1;
        }
        FluidStackKey key = new FluidStackKey(testStack, this.isCompareNBT);
        if (this.filterCountsFluid.containsKey(key)) {
            return this.filterCountsFluid.get(key);
        }
        FilterCountHandler filterSlotHandler = FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            Optional fluidHandlerLazyOptional;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.m_41619_() || (fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)itemStack).resolve()).isEmpty()) continue;
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (!key.equals(new FluidStackKey(fluidStack, this.isCompareNBT))) continue;
                int mbAmt = FilterCount.getSlotAmount(this.filterCard, i);
                this.filterCountsFluid.put(key, mbAmt);
                return mbAmt;
            }
        }
        this.filterCountsFluid.put(key, 0);
        return 0;
    }

    public List<ItemStack> getFilteredItems() {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        FilterBasicHandler filterSlotHandler = this.filterCard.m_41720_() instanceof FilterBasic ? FilterBasic.getInventory(this.filterCard) : FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            filteredItems.add(itemStack);
        }
        return filteredItems;
    }

    public List<FluidStack> getFilteredFluids() {
        ArrayList<FluidStack> filteredFluids = new ArrayList<FluidStack>();
        FilterBasicHandler filterSlotHandler = this.filterCard.m_41720_() instanceof FilterBasic ? FilterBasic.getInventory(this.filterCard) : FilterCount.getInventory(this.filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            Optional fluidHandlerLazyOptional;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.m_41619_() || (fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)itemStack).resolve()).isEmpty()) continue;
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
                if (fluidStack.isEmpty()) continue;
                filteredFluids.add(fluidStack);
            }
        }
        return filteredFluids;
    }

    public List<String> getFilterTags() {
        List<String> filterTags = new ArrayList<String>();
        if (this.filterCard.m_41720_() instanceof FilterTag) {
            filterTags = FilterTag.getTags(this.filterCard);
        }
        return filterTags;
    }

    public List<String> getFilterNBTs() {
        List<String> filterNBTs = new ArrayList<String>();
        if (this.filterCard.m_41720_() instanceof FilterNBT) {
            filterNBTs = FilterTag.getTags(this.filterCard);
        }
        return filterNBTs;
    }

    public boolean isStackValidForCard(ItemStack testStack) {
        if (this.filterCard.equals(ItemStack.f_41583_)) {
            return true;
        }
        ItemStackKey key = new ItemStackKey(testStack, this.isCompareNBT);
        if (this.filterCache.containsKey(key)) {
            return this.filterCache.get(key);
        }
        if (this.filterCard.m_41720_() instanceof FilterMod) {
            for (ItemStack stack : this.filteredItems) {
                if (!stack.m_41720_().getCreatorModId(stack).equals(testStack.m_41720_().getCreatorModId(testStack))) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.m_41720_() instanceof FilterTag) {
            for (TagKey tagKey : testStack.m_41720_().m_204114_().m_203616_().toList()) {
                String tag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                if (!this.filterTags.contains(tag)) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.m_41720_() instanceof FilterNBT) {
            for (String tag : testStack.m_41784_().m_128431_()) {
                if (!this.filterNBTs.contains(tag)) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else {
            for (ItemStack stack : this.filteredItems) {
                if (!key.equals(new ItemStackKey(stack, this.isCompareNBT))) continue;
                this.filterCache.put(key, this.isAllowList);
                return this.isAllowList;
            }
        }
        this.filterCache.put(key, !this.isAllowList);
        return !this.isAllowList;
    }

    public boolean isStackValidForCard(FluidStack testStack) {
        if (this.filterCard.equals(ItemStack.f_41583_)) {
            return true;
        }
        FluidStackKey key = new FluidStackKey(testStack, this.isCompareNBT);
        if (this.filterCacheFluid.containsKey(key)) {
            return this.filterCacheFluid.get(key);
        }
        if (this.filterCard.m_41720_() instanceof FilterMod) {
            for (FluidStack stack : this.filteredFluids) {
                if (!ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).m_135827_().equals(ForgeRegistries.FLUIDS.getKey((Object)testStack.getFluid()).m_135827_())) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else if (this.filterCard.m_41720_() instanceof FilterTag) {
            for (TagKey tagKey : testStack.getFluid().m_205069_().m_203616_().toList()) {
                String tag = tagKey.f_203868_().toString().toLowerCase(Locale.ROOT);
                if (!this.filterTags.contains(tag)) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        } else {
            for (FluidStack stack : this.filteredFluids) {
                if (!key.equals(new FluidStackKey(stack, this.isCompareNBT))) continue;
                this.filterCacheFluid.put(key, this.isAllowList);
                return this.isAllowList;
            }
        }
        this.filterCacheFluid.put(key, !this.isAllowList);
        return !this.isAllowList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseCardCache) {
            return ((Object)((Object)((BaseCardCache)obj).be)).equals((Object)this.be) && ((BaseCardCache)obj).direction.equals((Object)this.direction) && ((BaseCardCache)obj).cardSlot == this.cardSlot;
        }
        return false;
    }
}

