/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import de.keksuccino.justzoom.ZoomHandler;
import de.keksuccino.konkrete.config.Config;
import java.io.File;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

@Mod(value="justzoom")
public class JustZoom {
    private static Config config;
    public static final File MOD_DIRECTORY;
    public static final String VERSION = "1.0.2";

    public JustZoom() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            try {
                if (!MOD_DIRECTORY.isDirectory()) {
                    MOD_DIRECTORY.mkdirs();
                }
                JustZoom.updateConfig();
                ZoomHandler.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static Config getConfig() {
        if (config == null) {
            JustZoom.updateConfig();
        }
        return config;
    }

    public static void updateConfig() {
        try {
            config = new Config("config/justzoom/config.txt");
            config.registerValue("base_zoom_factor", Double.valueOf(0.25), "zoom", "The base zoom factor before zooming in or out.");
            config.registerValue("zoom_in_per_scroll", Double.valueOf(0.05), "zoom", "How much to zoom in per scroll.");
            config.registerValue("zoom_out_per_scroll", Double.valueOf(0.05), "zoom", "How much to zoom out per scroll.");
            config.registerValue("reset_zoom_factor", Boolean.valueOf(true), "zoom", "If the zoom factor should reset to the base zoom factor when stop zooming. Default = true");
            config.registerValue("zoom_out_cap", Boolean.valueOf(true), "zoom", "Caps the maximum FOV when zooming out, so you can't zoom out more than your normal FOV. Default = true");
            config.registerValue("lerp_amount", Double.valueOf(0.1), "zoom", "How fast the zoom should interpolate between the current FOV and the modified/zoomed FOV. Higher values mean faster interpolation. Default = 0.1 (10 frames), Min = 0.01 (100 frames), Max = 1 (1 frame)");
            config.registerValue("smooth_camera_on_zoom", Boolean.valueOf(true), "zoom", "If the camera should move smoothly when zoomed.");
            config.clearUnusedValues();
            if ((Double)config.getOrDefault("base_zoom_factor", (Object)0.25) > 1.0 || (Double)config.getOrDefault("base_zoom_factor", (Object)0.25) < 0.0) {
                config.setValue("base_zoom_factor", Double.valueOf(0.25));
            }
            if ((Double)config.getOrDefault("zoom_in_per_scroll", (Object)0.05) > 1.0 || (Double)config.getOrDefault("zoom_in_per_scroll", (Object)0.05) < 0.0) {
                config.setValue("zoom_in_per_scroll", Double.valueOf(0.05));
            }
            if ((Double)config.getOrDefault("zoom_out_per_scroll", (Object)0.05) > 1.0 || (Double)config.getOrDefault("zoom_out_per_scroll", (Object)0.05) < 0.0) {
                config.setValue("zoom_out_per_scroll", Double.valueOf(0.05));
            }
            if ((Double)config.getOrDefault("lerp_amount", (Object)0.1) > 1.0 || (Double)config.getOrDefault("lerp_amount", (Object)0.1) < 0.0) {
                config.setValue("lerp_amount", Double.valueOf(0.1));
            }
            config.syncConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        MOD_DIRECTORY = new File("config/justzoom");
    }
}

