/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.wall_of_fire.WallOfFireEntity;
import io.redspace.ironsspellbooks.network.ServerboundCancelCast;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class WallOfFireSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "wall_of_fire");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(20.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation(this.getWallLength(spellLevel, caster), 1)}));
    }

    public WallOfFireSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 10;
    }

    @Override
    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (playerMagicData.isCasting() && playerMagicData.getCastingSpellId().equals(this.getSpellId()) && playerMagicData.getAdditionalCastData() == null) {
            FireWallData fireWallData = new FireWallData(this.getWallLength(spellLevel, entity));
            playerMagicData.setAdditionalCastData(fireWallData);
        }
        super.onCast(world, spellLevel, entity, playerMagicData);
    }

    @Override
    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof FireWallData) {
            FireWallData fireWallData = (FireWallData)iCastData;
            if (fireWallData.ticks++ % 4 == 0) {
                this.addAnchor(fireWallData, level, entity);
            }
        }
    }

    @Override
    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof FireWallData) {
            FireWallData fireWallData = (FireWallData)iCastData;
            if (fireWallData.anchors.size() == 1) {
                this.addAnchor(fireWallData, level, entity);
            }
            if (fireWallData.anchors.size() > 0) {
                WallOfFireEntity fireWall = new WallOfFireEntity(level, (Entity)entity, fireWallData.anchors, this.getDamage(spellLevel, entity));
                Vec3 origin = fireWallData.anchors.get(0);
                for (int i = 1; i < fireWallData.anchors.size(); ++i) {
                    origin.m_82549_(fireWallData.anchors.get(i));
                }
                origin.m_82490_((double)(1.0f / (float)fireWallData.anchors.size()));
                fireWall.m_146884_(origin);
                level.m_7967_((Entity)fireWall);
            }
        }
        super.onServerCastComplete(level, spellLevel, entity, playerMagicData, false);
    }

    @Override
    public SpellDamageSource getDamageSource(@Nullable Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFireTime(4);
    }

    private float getWallLength(int spellLevel, LivingEntity entity) {
        return 10 + this.getLevel(spellLevel, entity) * 2;
    }

    private float getDamage(int spellLevel, LivingEntity sourceEntity) {
        return this.getSpellPower(spellLevel, (Entity)sourceEntity);
    }

    public void addAnchor(FireWallData fireWallData, Level level, LivingEntity entity) {
        Vec3 anchor = Utils.getTargetBlock(level, entity, ClipContext.Fluid.ANY, 20.0).m_82450_();
        anchor = this.setOnGround(anchor, level);
        List<Vec3> anchorPoints = fireWallData.anchors;
        if (anchorPoints.size() == 0) {
            anchorPoints.add(anchor);
        } else {
            float maxDistance;
            int i = anchorPoints.size();
            float distance = (float)anchorPoints.get(i - 1).m_82554_(anchor);
            if (distance <= (maxDistance = fireWallData.maxTotalDistance - fireWallData.accumulatedDistance)) {
                fireWallData.accumulatedDistance += distance;
                anchorPoints.add(anchor);
            } else {
                anchor = anchorPoints.get(i - 1).m_82549_(anchor.m_82546_(anchorPoints.get(i - 1)).m_82541_().m_82490_((double)maxDistance));
                anchor = this.setOnGround(anchor, level);
                anchorPoints.add(anchor);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                    boolean triggerCooldown = playerMagicData.getCastSource() != CastSource.SCROLL;
                    ServerboundCancelCast.cancelCast(serverPlayer, triggerCooldown);
                }
            }
        }
        MagicManager.spawnParticles(level, (ParticleOptions)ParticleTypes.f_123744_, anchor.f_82479_, anchor.f_82480_ + 1.5, anchor.f_82481_, 5, 0.05, 0.25, 0.05, 0.0, true);
    }

    private Vec3 setOnGround(Vec3 in, Level level) {
        if (level.m_8055_(BlockPos.m_274561_((double)in.f_82479_, (double)(in.f_82480_ + 0.5), (double)in.f_82481_)).m_60795_()) {
            for (int i = 0; i < 15; ++i) {
                if (level.m_8055_(BlockPos.m_274561_((double)in.f_82479_, (double)(in.f_82480_ - (double)i), (double)in.f_82481_)).m_60795_()) continue;
                return new Vec3(in.f_82479_, in.f_82480_ - (double)i + 1.0, in.f_82481_);
            }
            return new Vec3(in.f_82479_, in.f_82480_ - 15.0, in.f_82481_);
        }
        double y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)in.f_82479_, (int)in.f_82481_);
        return new Vec3(in.f_82479_, y, in.f_82481_);
    }

    public class FireWallData
    implements ICastData {
        private Entity castingEntity;
        public List<Vec3> anchors = new ArrayList<Vec3>();
        public float maxTotalDistance;
        public float accumulatedDistance;
        public int ticks;

        FireWallData(float maxTotalDistance) {
            this.maxTotalDistance = maxTotalDistance;
        }

        @Override
        public void reset() {
        }
    }
}

