/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.player.SpinAttackType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class BurningDashSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "burning_dash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(10).setCooldownSeconds(10.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation(this.getDamage(spellLevel, caster), 2)}));
    }

    public BurningDashSpell() {
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 20;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData bdcd = (ImpulseCastData)castData;
            entity.f_19812_ = bdcd.hasImpulse;
            entity.m_20256_(entity.m_20184_().m_82520_((double)bdcd.x, (double)bdcd.y, (double)bdcd.z));
        }
        super.onClientCast(level, spellLevel, entity, castData);
    }

    @Override
    public ICastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        entity.f_19812_ = true;
        float multiplier = (15.0f + this.getSpellPower(spellLevel, (Entity)entity)) / 12.0f;
        Vec3 forward = entity.m_20154_();
        if (playerMagicData.getAdditionalCastData() instanceof BurningDashDirectionOverrideCastData) {
            forward = Utils.random.m_188499_() ? forward.m_82524_(90.0f) : forward.m_82524_(-90.0f);
        }
        Vec3 vec = forward.m_82542_(3.0, 1.0, 3.0).m_82541_().m_82520_(0.0, 0.25, 0.0).m_82490_((double)multiplier);
        playerMagicData.setAdditionalCastData(new ImpulseCastData((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_, true));
        entity.m_20256_(entity.m_20184_().m_82549_(vec));
        if (entity.m_20096_()) {
            entity.m_146884_(entity.m_20182_().m_82520_(0.0, 1.2, 0.0));
        }
        this.startSpinAttack(entity, 10);
        world.m_45933_((Entity)entity, entity.m_20191_().m_82400_(4.0)).forEach(target -> {
            if (target.m_20280_((Entity)entity) < 16.0) {
                DamageSources.applyDamage(target, this.getDamage(spellLevel, entity), this.getDamageSource((Entity)entity), this.getSchoolType());
            }
        });
        MagicManager.spawnParticles(world, ParticleHelper.FIRE, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 75, 1.0, 0.0, 1.0, 0.08, false);
        playerMagicData.getSyncedData().setSpinAttackType(SpinAttackType.FIRE);
        super.onCast(world, spellLevel, entity, playerMagicData);
    }

    @Override
    public SpellDamageSource getDamageSource(@Nullable Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFireTime(4);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 5.0f + this.getSpellPower(spellLevel, (Entity)caster) / 2.0f;
    }

    private void startSpinAttack(LivingEntity entity, int durationInTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_204079_(durationInTicks);
        } else if (entity instanceof AbstractSpellCastingMob) {
            AbstractSpellCastingMob mob = (AbstractSpellCastingMob)entity;
            mob.startAutoSpinAttack(durationInTicks);
        }
    }

    public static class BurningDashDirectionOverrideCastData
    implements ICastData {
        @Override
        public void reset() {
        }
    }
}

