/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

@AutoSpellConfig
public class RecallSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "recall");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(300.0).build();

    public RecallSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 100;
    }

    @Override
    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RECALL_PREPARE.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        this.playSound(this.getCastFinishSound(), (Entity)entity, false);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ServerLevel respawnLevel = ((ServerLevel)world).m_7654_().m_129880_(serverPlayer.m_8963_());
            respawnLevel = respawnLevel == null ? world.m_7654_().m_129783_() : respawnLevel;
            Optional<Vec3> spawnLocation = RecallSpell.findSpawnPosition(respawnLevel, serverPlayer);
            IronsSpellbooks.LOGGER.debug("Recall.onCast findSpawnLocation: {}", spawnLocation);
            if (spawnLocation.isPresent()) {
                Vec3 vec3 = spawnLocation.get();
                IronsSpellbooks.LOGGER.debug("Recall.onCast.a dimension: {} -> {}", (Object)serverPlayer.f_19853_.m_46472_(), (Object)respawnLevel.m_46472_());
                if (serverPlayer.f_19853_.m_46472_() != respawnLevel.m_46472_()) {
                    serverPlayer.changeDimension(respawnLevel, (ITeleporter)new PortalTeleporter(vec3));
                } else {
                    serverPlayer.m_6021_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            } else {
                respawnLevel = world.m_7654_().m_129783_();
                IronsSpellbooks.LOGGER.debug("Recall.onCast.b dimension: {} -> {}", (Object)serverPlayer.f_19853_.m_46472_(), (Object)respawnLevel.m_46472_());
                if (serverPlayer.f_19853_.m_46472_() != respawnLevel.m_46472_()) {
                    serverPlayer.changeDimension(respawnLevel, (ITeleporter)new PortalTeleporter(Vec3.f_82478_));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132153_, 0.0f));
                BlockPos pos = respawnLevel.m_220360_();
                serverPlayer.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
        }
        super.onCast(world, spellLevel, entity, playerMagicData);
    }

    public static void ambientParticles(LivingEntity entity, SyncedSpellData spellData) {
        float f = (float)entity.f_19797_ * 0.125f;
        Vec3 trail1 = new Vec3((double)Mth.m_14089_((float)f), (double)Mth.m_14031_((float)(f * 2.0f)), (double)Mth.m_14031_((float)f)).m_82541_();
        Vec3 trail2 = new Vec3((double)Mth.m_14031_((float)f), (double)Mth.m_14089_((float)(f * 2.0f)), (double)Mth.m_14089_((float)f)).m_82541_();
        Vec3 trail3 = trail1.m_82559_(trail2).m_82541_().m_82490_((double)(1.0f + (Mth.m_14031_((float)f) + Mth.m_14089_((float)f)) * 0.5f));
        Vec3 pos = entity.m_20191_().m_82399_();
        entity.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, pos.f_82479_ + trail1.f_82479_, pos.f_82480_ + trail1.f_82480_, pos.f_82481_ + trail1.f_82481_, 0.0, 0.0, 0.0);
        entity.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, pos.f_82479_ + trail2.f_82479_, pos.f_82480_ + trail2.f_82480_, pos.f_82481_ + trail2.f_82481_, 0.0, 0.0, 0.0);
        entity.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, pos.f_82479_ + trail3.f_82479_, pos.f_82480_ + trail3.f_82480_, pos.f_82481_ + trail3.f_82481_, 0.0, 0.0, 0.0);
    }

    @Override
    protected void playSound(Optional<SoundEvent> sound, Entity entity, boolean playDefaultSound) {
        sound.ifPresent(soundEvent -> entity.m_5496_(soundEvent, 2.0f, 1.0f));
    }

    public static Optional<Vec3> findSpawnPosition(ServerLevel level, ServerPlayer player) {
        BlockPos spawnBlockpos = player.m_8961_();
        if (spawnBlockpos == null) {
            return Optional.empty();
        }
        BlockState blockstate = level.m_8055_(spawnBlockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof RespawnAnchorBlock && (Integer)blockstate.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && RespawnAnchorBlock.m_55850_((Level)level)) {
            IronsSpellbooks.LOGGER.debug("RecallSpell.findSpawnPosition.respawnAnchor");
            return RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)spawnBlockpos);
        }
        if (block instanceof BedBlock && BedBlock.m_49488_((Level)level)) {
            IronsSpellbooks.LOGGER.debug("RecallSpell.findSpawnPosition.bed");
            return BedBlock.m_260958_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)spawnBlockpos, (Direction)player.m_6350_(), (float)player.m_146908_());
        }
        return Optional.empty();
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_ANIMATION;
    }

    @Override
    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.none();
    }

    @Override
    public boolean stopSoundOnCancel() {
        return true;
    }

    public static class PortalTeleporter
    implements ITeleporter {
        private final Vec3 destinationPosition;

        PortalTeleporter(Vec3 destinationPosition) {
            this.destinationPosition = destinationPosition;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            entity.f_19789_ = 0.0f;
            return repositionEntity.apply(false);
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(this.destinationPosition, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }

        public boolean isVanilla() {
            return false;
        }

        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
            return false;
        }
    }
}

