/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class CommonPlayerEvents {
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (Utils.canImbue(stack)) {
            SpellData spellData = SpellData.getSpellData(stack);
            InteractionResultHolder<ItemStack> result = Utils.onUseCastingHelper(event.getLevel(), event.getEntity(), event.getHand(), stack, spellData);
            if (result != null) {
                event.setCancellationResult(result.m_19089_());
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItemStop(LivingEntityUseItemEvent.Stop event) {
        ItemStack stack = event.getItem();
        if (Utils.canImbue(stack)) {
            AbstractSpell spell = SpellData.getSpellData(stack).getSpell();
            LivingEntity entity = event.getEntity();
            if (spell != SpellRegistry.none()) {
                entity.m_5810_();
                Utils.releaseUsingHelper(entity, stack, event.getDuration());
            }
        }
    }
}

