/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.gui.overlays.SpellWheelOverlay;
import io.redspace.ironsspellbooks.gui.overlays.network.ServerboundSetSpellBookActiveIndex;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import io.redspace.ironsspellbooks.player.KeyMappings;
import io.redspace.ironsspellbooks.player.KeyState;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="irons_spellbooks", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class ClientInputEvents {
    private static final ArrayList<KeyState> KEY_STATES = new ArrayList();
    private static final KeyState SPELL_WHEEL_STATE = ClientInputEvents.register(KeyMappings.SPELL_WHEEL_KEYMAP);
    private static final KeyState SPELLBAR_MODIFIER_STATE = ClientInputEvents.register(KeyMappings.SPELLBAR_SCROLL_MODIFIER_KEYMAP);
    private static final List<KeyState> QUICK_CAST_STATES = ClientInputEvents.registerQuickCast(KeyMappings.QUICK_CAST_MAPPINGS);
    private static int useKeyId = Integer.MIN_VALUE;
    public static boolean isUseKeyDown;
    public static boolean hasReleasedSinceCasting;
    public static boolean isShiftKeyDown;
    public static int test;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (SPELL_WHEEL_STATE.wasPressed() && minecraft.f_91080_ == null && Utils.isPlayerHoldingSpellBook((Player)player)) {
            SpellWheelOverlay.instance.open();
        }
        if (SPELL_WHEEL_STATE.wasReleased() && minecraft.f_91080_ == null && SpellWheelOverlay.instance.active) {
            SpellWheelOverlay.instance.close();
        }
        ClientInputEvents.update();
    }

    @SubscribeEvent
    public static void clientMouseScrolled(InputEvent.MouseScrollingEvent event) {
        ItemStack spellBookStack;
        SpellBookData spellBookData;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (Utils.isPlayerHoldingSpellBook((Player)player) && minecraft.f_91080_ == null && SPELLBAR_MODIFIER_STATE.isHeld() && (spellBookData = SpellBookData.getSpellBookData(spellBookStack = player.m_21205_().m_41720_() instanceof SpellBook ? player.m_21205_() : player.m_21206_())).getSpellCount() > 0) {
            int direction = (int)event.getScrollDelta();
            ArrayList<SpellData> spells = new ArrayList<SpellData>();
            for (SpellData spellData : spellBookData.getInscribedSpells()) {
                if (spellData == null) continue;
                spells.add(spellData);
            }
            int spellCount = spellBookData.getSpellCount();
            int scrollIndex = spells.indexOf(spellBookData.getActiveSpell()) - direction;
            scrollIndex = (Mth.m_14045_((int)scrollIndex, (int)-1, (int)(spellCount + 1)) + spellCount) % spellCount;
            int selectedIndex = ArrayUtils.indexOf((Object[])spellBookData.getInscribedSpells(), spells.get(scrollIndex));
            Messages.sendToServer(new ServerboundSetSpellBookActiveIndex(selectedIndex));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isUseItem()) {
            if (ClientSpellCastHelper.shouldSuppressRightClicks()) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        } else if (event.isAttack() && ClientMagicData.isCasting()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ClientInputEvents.handleRightClickSuppression(event.getKey(), event.getAction());
        if (event.getKey() == 340) {
            isShiftKeyDown = event.getAction() >= 1;
        }
        for (int i = 0; i < QUICK_CAST_STATES.size(); ++i) {
            if (!QUICK_CAST_STATES.get(i).wasPressed()) continue;
            Utils.quickCast(i);
            break;
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        ClientInputEvents.handleRightClickSuppression(event.getButton(), event.getAction());
    }

    private static void handleRightClickSuppression(int button, int action) {
        if (useKeyId == Integer.MIN_VALUE) {
            useKeyId = Minecraft.m_91087_().f_91066_.f_92095_.getKey().m_84873_();
        }
        if (button == useKeyId) {
            if (action == 0) {
                ClientSpellCastHelper.setSuppressRightClicks(false);
                isUseKeyDown = false;
                hasReleasedSinceCasting = true;
            } else if (action == 1) {
                isUseKeyDown = true;
            }
        }
    }

    private static void update() {
        for (KeyState k : KEY_STATES) {
            k.update();
        }
    }

    private static KeyState register(KeyMapping key) {
        KeyState k = new KeyState(key);
        KEY_STATES.add(k);
        return k;
    }

    private static List<KeyState> registerQuickCast(List<KeyMapping> mappings) {
        ArrayList<KeyState> keyStates = new ArrayList<KeyState>();
        mappings.forEach(keyMapping -> {
            KeyState k = new KeyState((KeyMapping)keyMapping);
            KEY_STATES.add(k);
            keyStates.add(k);
        });
        return keyStates;
    }

    static {
        test = 0;
    }
}

