/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipe;
import io.redspace.ironsspellbooks.jei.JeiPlugin;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ArcaneAnvilRecipeCategory
implements IRecipeCategory<ArcaneAnvilRecipe> {
    public static final RecipeType<ArcaneAnvilRecipe> ARCANE_ANVIL_RECIPE_RECIPE_TYPE = RecipeType.create((String)"irons_spellbooks", (String)"arcane_anvil", ArcaneAnvilRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final String leftSlotName = "leftSlot";
    private final String rightSlotName = "rightSlot";
    private final String outputSlotName = "outputSlot";
    private final int paddingBottom = 15;

    public ArcaneAnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(JeiPlugin.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 15, 0, 0).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.ARCANE_ANVIL_BLOCK.get()));
    }

    public RecipeType<ArcaneAnvilRecipe> getRecipeType() {
        return ARCANE_ANVIL_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return ((Block)BlockRegistry.ARCANE_ANVIL_BLOCK.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ArcaneAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> leftInputs = recipe.leftInputs();
        List<ItemStack> rightInputs = recipe.rightInputs();
        List<ItemStack> outputs = recipe.outputs();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(leftInputs)).setSlotName("leftSlot");
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addItemStacks(rightInputs)).setSlotName("rightSlot");
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(outputs)).setSlotName("outputSlot");
        if (leftInputs.size() == rightInputs.size()) {
            if (leftInputs.size() == outputs.size()) {
                builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, rightInputSlot, outputSlot});
            }
        } else if (leftInputs.size() == outputs.size() && rightInputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, outputSlot});
        } else if (rightInputs.size() == outputs.size() && leftInputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{rightInputSlot, outputSlot});
        }
    }

    public void draw(ArcaneAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("leftSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional rightStack = recipeSlotsView.findSlotByName("rightSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional outputStack = recipeSlotsView.findSlotByName("outputSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        if (leftStack.isEmpty() || rightStack.isEmpty() || outputStack.isEmpty()) {
            return;
        }
        if (((ItemStack)leftStack.get()).m_41720_() instanceof Scroll && ((ItemStack)rightStack.get()).m_41720_() instanceof Scroll && ((ItemStack)outputStack.get()).m_41720_() instanceof Scroll) {
            Minecraft minecraft = Minecraft.m_91087_();
            this.drawScrollInfo(minecraft, guiGraphics, (ItemStack)leftStack.get(), (ItemStack)outputStack.get());
        }
    }

    private void drawScrollInfo(Minecraft minecraft, GuiGraphics guiGraphics, ItemStack leftStack, ItemStack outputStack) {
        SpellData inputSpellData = SpellData.getSpellData(leftStack);
        String inputText = String.format("L%d", inputSpellData.getLevel());
        int inputColor = inputSpellData.getSpell().getRarity(inputSpellData.getLevel()).getChatFormatting().m_126665_();
        SpellData outputSpellData = SpellData.getSpellData(outputStack);
        String outputText = String.format("L%d", outputSpellData.getLevel());
        int outputColor = outputSpellData.getSpell().getRarity(outputSpellData.getLevel()).getChatFormatting().m_126665_();
        int n = this.getHeight() / 2 + 7;
        Objects.requireNonNull(minecraft.f_91062_);
        int y = n + 9 / 2 - 4;
        int x = 3;
        guiGraphics.m_280488_(minecraft.f_91062_, inputText, x, y, inputColor);
        guiGraphics.m_280488_(minecraft.f_91062_, inputText, x += 50, y, inputColor);
        int outputWidth = minecraft.f_91062_.m_92895_(outputText);
        guiGraphics.m_280488_(minecraft.f_91062_, outputText, this.getWidth() - (outputWidth + 3), y, outputColor);
    }
}

