/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.jei.AlchemistCauldronJeiRecipe;
import io.redspace.ironsspellbooks.jei.JeiPlugin;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class AlchemistCauldronRecipeCategory
implements IRecipeCategory<AlchemistCauldronJeiRecipe> {
    public static final RecipeType<AlchemistCauldronJeiRecipe> ALCHEMIST_CAULDRON_RECIPE_TYPE = RecipeType.create((String)"irons_spellbooks", (String)"alchemist_cauldron", AlchemistCauldronJeiRecipe.class);
    private final IDrawable background;
    private final IDrawable cauldron_block_icon;
    private final String inputSlotName = "inputSlot";
    private final String catalystSlotName = "catalystSlot";
    private final String outputSlotName = "outputSlot";
    private final int paddingBottom = 20;

    public AlchemistCauldronRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(JeiPlugin.ALCHEMIST_CAULDRON_GUI, 0, 0, 125, 18).addPadding(0, 20, 0, 0).build();
        this.cauldron_block_icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.ALCHEMIST_CAULDRON.get()));
    }

    public RecipeType<AlchemistCauldronJeiRecipe> getRecipeType() {
        return ALCHEMIST_CAULDRON_RECIPE_TYPE;
    }

    public Component getTitle() {
        return ((Block)BlockRegistry.ALCHEMIST_CAULDRON.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.cauldron_block_icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlchemistCauldronJeiRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = recipe.inputs();
        List<ItemStack> catalysts = recipe.catalysts();
        List<ItemStack> outputs = recipe.outputs();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(inputs)).setSlotName("inputSlot");
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 54, 1).addItemStacks(catalysts)).setSlotName("catalystSlot");
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(outputs)).setSlotName("outputSlot");
        if (inputs.size() == catalysts.size()) {
            if (inputs.size() == outputs.size()) {
                builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, rightInputSlot, outputSlot});
            }
        } else if (inputs.size() == outputs.size() && catalysts.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, outputSlot});
        } else if (catalysts.size() == outputs.size() && inputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{rightInputSlot, outputSlot});
        }
    }

    public void draw(@NotNull AlchemistCauldronJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiHelper, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("inputSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional rightStack = recipeSlotsView.findSlotByName("catalystSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional outputStack = recipeSlotsView.findSlotByName("outputSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        guiHelper.m_280168_().m_85836_();
        guiHelper.m_280168_().m_252880_((float)(this.getWidth() / 2) - 11.2f, (float)(this.getHeight() / 2 - 2), 0.0f);
        guiHelper.m_280168_().m_85841_(1.4f, 1.4f, 1.4f);
        this.cauldron_block_icon.draw(guiHelper);
        guiHelper.m_280168_().m_85849_();
        if (leftStack.isPresent() && ((ItemStack)leftStack.get()).m_150930_((Item)ItemRegistry.SCROLL.get())) {
            String inputText = String.format("%s%%", (int)((Double)ServerConfigs.SCROLL_RECYCLE_CHANCE.get() * 100.0));
            Font font = Minecraft.m_91087_().f_91062_;
            int y = this.getHeight() / 2 - 14;
            int x = (this.getWidth() - font.m_92895_(inputText)) / 2;
            guiHelper.m_280488_(font, inputText, x, y, ChatFormatting.RED.m_126665_().intValue());
        }
    }
}

