/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronBlock;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronInteraction;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.consumables.SimpleElixir;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class AlchemistCauldronTile
extends BlockEntity
implements WorldlyContainer {
    public Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> interactions = AlchemistCauldronTile.newInteractionMap();
    public final NonNullList<ItemStack> inputItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> resultItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cooktimes = new int[4];

    public AlchemistCauldronTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockRegistry.ALCHEMIST_CAULDRON_TILE.get(), pWorldPosition, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, AlchemistCauldronTile cauldronTile) {
        for (int i = 0; i < cauldronTile.inputItems.size(); ++i) {
            ItemStack itemStack = (ItemStack)cauldronTile.inputItems.get(i);
            if (itemStack.m_41619_() || !AlchemistCauldronBlock.isBoiling(blockState)) {
                cauldronTile.cooktimes[i] = 0;
            } else {
                int n = i;
                cauldronTile.cooktimes[n] = cauldronTile.cooktimes[n] + 1;
            }
            if (cauldronTile.cooktimes[i] <= 100) continue;
            cauldronTile.meltComponent(itemStack);
            cauldronTile.cooktimes[i] = 0;
        }
        RandomSource random = Utils.random;
        if (AlchemistCauldronBlock.isBoiling(blockState)) {
            float waterLevel = Mth.m_14179_((float)((float)AlchemistCauldronBlock.getLevel(blockState) / 4.0f), (float)0.25f, (float)0.9f);
            MagicManager.spawnParticles(level, (ParticleOptions)ParticleTypes.f_123772_, (float)pos.m_123341_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), (float)pos.m_123342_() + waterLevel, (float)pos.m_123343_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
    }

    public InteractionResult handleUse(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack item;
        ItemStack itemStack = player.m_21120_(hand);
        int currentLevel = (Integer)blockState.m_61143_((Property)AlchemistCauldronBlock.LEVEL);
        ItemStack cauldronInteractionResult = ((AlchemistCauldronInteraction)this.interactions.get((Object)itemStack.m_41720_())).interact(blockState, level, pos, currentLevel, itemStack);
        if (cauldronInteractionResult != null) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)cauldronInteractionResult));
            this.m_6596_();
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (this.isValidInput(itemStack)) {
            if (!level.f_46443_ && AlchemistCauldronTile.appendItem(this.inputItems, itemStack)) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_6596_();
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_41619_() && hand.equals((Object)InteractionHand.MAIN_HAND) && !(item = AlchemistCauldronTile.grabItem(this.inputItems)).m_41619_()) {
            if (!level.f_46443_) {
                player.m_21008_(hand, item);
                this.m_6596_();
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void meltComponent(ItemStack itemStack) {
        if (this.f_58857_ == null) {
            return;
        }
        boolean shouldMelt = false;
        boolean success = true;
        if (itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) && !AlchemistCauldronTile.isFull(this.resultItems)) {
            if ((double)Utils.random.m_188501_() < (Double)ServerConfigs.SCROLL_RECYCLE_CHANCE.get()) {
                ItemStack result = new ItemStack((ItemLike)AlchemistCauldronTile.getInkFromScroll(itemStack));
                AlchemistCauldronTile.appendItem(this.resultItems, result);
            } else {
                success = false;
            }
            shouldMelt = true;
        }
        if (!shouldMelt && AlchemistCauldronTile.isBrewable(itemStack)) {
            for (int i = 0; i < this.resultItems.size(); ++i) {
                ItemStack potentialPotion = (ItemStack)this.resultItems.get(i);
                ItemStack output = BrewingRecipeRegistry.getOutput((ItemStack)(potentialPotion.m_41619_() ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_) : potentialPotion), (ItemStack)itemStack);
                if (output.m_41619_()) continue;
                this.resultItems.set(i, (Object)output);
                shouldMelt = true;
            }
        }
        if (!shouldMelt && AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack)) {
            for (int i = 0; i < this.resultItems.size(); ++i) {
                ItemStack potentialInput = ((ItemStack)this.resultItems.get(i)).m_41777_();
                ArrayList<Integer> matchingItems = new ArrayList<Integer>(List.of(Integer.valueOf(i)));
                if (!potentialInput.m_41619_()) {
                    for (int j = 0; j < this.resultItems.size(); ++j) {
                        if (j == i || !ItemStack.m_150942_((ItemStack)((ItemStack)this.resultItems.get(j)), (ItemStack)potentialInput)) continue;
                        int c = ((ItemStack)this.resultItems.get(j)).m_41613_();
                        potentialInput.m_41769_(c);
                        matchingItems.add(j);
                    }
                }
                int inputsCollected = potentialInput.m_41613_();
                ItemStack output = AlchemistCauldronRecipeRegistry.getOutput(potentialInput, itemStack.m_41777_(), true);
                if (output.m_41619_()) continue;
                int inputsToConsume = inputsCollected - potentialInput.m_41613_();
                for (Integer integer : matchingItems) {
                    if (inputsToConsume <= 0) continue;
                    int c = ((ItemStack)this.resultItems.get(integer.intValue())).m_41613_();
                    ((ItemStack)this.resultItems.get(integer.intValue())).m_41774_(c);
                    inputsToConsume -= c;
                }
                for (int j = 0; j < this.resultItems.size(); ++j) {
                    if (!matchingItems.contains(j) || output.m_41613_() < 1) continue;
                    this.resultItems.set(j, (Object)output.m_41620_(1));
                }
                shouldMelt = true;
                break;
            }
        }
        if (shouldMelt) {
            itemStack.m_41774_(1);
            this.m_6596_();
            if (success) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.MASTER, 1.0f, 1.0f);
                this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 1);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    public boolean isValidInput(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) || AlchemistCauldronTile.isBrewable(itemStack) || AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack);
    }

    public static boolean isBrewable(ItemStack itemStack) {
        return (Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get() != false && BrewingRecipeRegistry.isValidIngredient((ItemStack)itemStack);
    }

    public int getItemWaterColor(ItemStack itemStack) {
        if (this.m_58904_() == null) {
            return 0;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SimpleElixir) {
            SimpleElixir simpleElixir = (SimpleElixir)item;
            return simpleElixir.getMobEffect().m_19544_().m_19484_();
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_COMMON.get())) {
            return 0x222222;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_UNCOMMON.get())) {
            return 1196800;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_RARE.get())) {
            return 997444;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_EPIC.get())) {
            return 10825376;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_LEGENDARY.get())) {
            return 16559900;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.BLOOD_VIAL.get())) {
            return 5965590;
        }
        if (PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43598_) {
            return PotionUtils.m_43575_((ItemStack)itemStack);
        }
        return BiomeColors.m_108811_((BlockAndTintGetter)this.m_58904_(), (BlockPos)this.m_58899_());
    }

    public int getAverageWaterColor() {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        for (ItemStack itemStack : this.resultItems) {
            int k = this.getItemWaterColor(itemStack);
            f += (float)(k >> 16 & 0xFF) / 255.0f;
            f1 += (float)(k >> 8 & 0xFF) / 255.0f;
            f2 += (float)(k >> 0 & 0xFF) / 255.0f;
        }
        f = f / 4.0f * 255.0f;
        f1 = f1 / 4.0f * 255.0f;
        f2 = f2 / 4.0f * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Item getInkFromScroll(ItemStack scrollStack) {
        if (scrollStack.m_41720_() instanceof Scroll) {
            SpellData spellData = SpellData.getSpellData(scrollStack);
            SpellRarity rarity = spellData.getSpell().getRarity(spellData.getLevel());
            return switch (rarity) {
                case SpellRarity.COMMON -> (Item)ItemRegistry.INK_COMMON.get();
                case SpellRarity.UNCOMMON -> (Item)ItemRegistry.INK_UNCOMMON.get();
                case SpellRarity.RARE -> (Item)ItemRegistry.INK_RARE.get();
                case SpellRarity.EPIC -> (Item)ItemRegistry.INK_EPIC.get();
                case SpellRarity.LEGENDARY -> (Item)ItemRegistry.INK_LEGENDARY.get();
                default -> (Item)ItemRegistry.INK_COMMON.get();
            };
        }
        return null;
    }

    public static boolean appendItem(NonNullList<ItemStack> container, ItemStack newItem) {
        for (int i = 0; i < container.size(); ++i) {
            if (!((ItemStack)container.get(i)).m_41619_()) continue;
            ItemStack newItemCopy = newItem.m_41777_();
            newItemCopy.m_41764_(1);
            container.set(i, (Object)newItemCopy);
            IronsSpellbooks.LOGGER.debug("{}", (Object)container.toString());
            return true;
        }
        return false;
    }

    public static ItemStack grabItem(NonNullList<ItemStack> container) {
        for (int i = container.size() - 1; i >= 0; --i) {
            ItemStack item = (ItemStack)container.get(i);
            if (item.m_41619_()) continue;
            return item.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public static boolean isEmpty(NonNullList<ItemStack> container) {
        for (ItemStack itemStack : container) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isFull(NonNullList<ItemStack> container) {
        for (ItemStack itemStack : container) {
            if (!itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        Utils.loadAllItems(tag, this.inputItems, "Items");
        Utils.loadAllItems(tag, this.resultItems, "Results");
        super.m_142466_(tag);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        Utils.saveAllItems(tag, this.inputItems, "Items");
        Utils.saveAllItems(tag, this.resultItems, "Results");
        super.m_183515_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.inputItems.clear();
        this.resultItems.clear();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inputItems.size());
        for (int i = 0; i < this.inputItems.size(); ++i) {
            simpleContainer.m_6836_(i, (ItemStack)this.inputItems.get(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
        }
    }

    static Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> newInteractionMap() {
        Object2ObjectOpenHashMap map = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), o2o -> o2o.defaultReturnValue((blockState, level, blockPos, i, itemStack) -> null));
        map.put((Object)Items.f_42447_, (blockState, level, pos, currentLevel, itemstack) -> {
            if (currentLevel < 4) {
                return AlchemistCauldronTile.createFilledResult(level, blockState, pos, 4, new ItemStack((ItemLike)Items.f_42446_), SoundEvents.f_11778_);
            }
            return null;
        });
        map.put((Object)Items.f_42446_, (blockState, level, pos, currentLevel, itemstack) -> {
            BlockEntity patt18302$temp = level.m_7702_(pos);
            if (patt18302$temp instanceof AlchemistCauldronTile) {
                AlchemistCauldronTile tile = (AlchemistCauldronTile)patt18302$temp;
                if (AlchemistCauldronTile.isEmpty(tile.resultItems) && currentLevel == 4) {
                    return AlchemistCauldronTile.createFilledResult(level, blockState, pos, 0, new ItemStack((ItemLike)Items.f_42447_), SoundEvents.f_11781_);
                }
            }
            return null;
        });
        map.put((Object)Items.f_42590_, (blockState, level, pos, currentLevel, itemstack) -> {
            BlockEntity patt18778$temp;
            if (currentLevel > 0 && (patt18778$temp = level.m_7702_(pos)) instanceof AlchemistCauldronTile) {
                AlchemistCauldronTile tile = (AlchemistCauldronTile)patt18778$temp;
                NonNullList<ItemStack> storedItems = tile.resultItems;
                if (AlchemistCauldronTile.isEmpty(storedItems)) {
                    return AlchemistCauldronTile.createFilledResult(level, blockState, pos, currentLevel - 1, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), SoundEvents.f_11770_);
                }
                return AlchemistCauldronTile.createFilledResult(level, blockState, pos, currentLevel, AlchemistCauldronTile.grabItem(storedItems), SoundEvents.f_11771_);
            }
            return null;
        });
        map.put((Object)Items.f_42589_, (blockState, level, pos, currentLevel, itemstack) -> {
            if (PotionUtils.m_43579_((ItemStack)itemstack) == Potions.f_43599_) {
                if (currentLevel < 4) {
                    return AlchemistCauldronTile.createFilledResult(level, blockState, pos, currentLevel + 1, new ItemStack((ItemLike)Items.f_42590_), SoundEvents.f_11769_);
                }
            } else {
                BlockEntity patt20069$temp = level.m_7702_(pos);
                if (patt20069$temp instanceof AlchemistCauldronTile) {
                    AlchemistCauldronTile tile = (AlchemistCauldronTile)patt20069$temp;
                    if (!AlchemistCauldronTile.isFull(tile.resultItems)) {
                        AlchemistCauldronTile.appendItem(tile.resultItems, itemstack);
                        return AlchemistCauldronTile.createFilledResult(level, blockState, pos, Math.min(currentLevel + 1, 4), new ItemStack((ItemLike)Items.f_42590_), SoundEvents.f_11769_);
                    }
                }
            }
            return null;
        });
        AlchemistCauldronTile.createInkInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_COMMON);
        AlchemistCauldronTile.createInkInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_UNCOMMON);
        AlchemistCauldronTile.createInkInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_RARE);
        AlchemistCauldronTile.createInkInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_EPIC);
        AlchemistCauldronTile.createInkInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_LEGENDARY);
        return map;
    }

    private static void createInkInteraction(Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> map, RegistryObject<Item> ink) {
        map.put((Object)((Item)ink.get()), (blockState, level, pos, currentLevel, itemstack) -> {
            BlockEntity patt21027$temp;
            if (currentLevel > 0 && (patt21027$temp = level.m_7702_(pos)) instanceof AlchemistCauldronTile) {
                AlchemistCauldronTile tile = (AlchemistCauldronTile)patt21027$temp;
                if (!AlchemistCauldronTile.isFull(tile.resultItems)) {
                    AlchemistCauldronTile.appendItem(tile.resultItems, itemstack);
                    return AlchemistCauldronTile.createFilledResult(level, blockState, pos, currentLevel, new ItemStack((ItemLike)Items.f_42590_), SoundEvents.f_11769_);
                }
            }
            return null;
        });
    }

    private static ItemStack createFilledResult(Level level, BlockState blockState, BlockPos blockPos, int newLevel, ItemStack resultItem, SoundEvent soundEvent) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)AlchemistCauldronBlock.LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
        level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        return resultItem;
    }

    public int[] m_7071_(Direction pSide) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return !AlchemistCauldronTile.isFull(this.inputItems) && this.isValidInput(pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public void m_6211_() {
        IronsSpellbooks.LOGGER.debug("AlchemistCauldronTile.clearContents");
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        return AlchemistCauldronTile.isEmpty(this.inputItems);
    }

    public ItemStack m_8020_(int pSlot) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.f_41583_;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        if (pSlot >= 0 && pSlot <= this.inputItems.size()) {
            if (((ItemStack)this.inputItems.get(pSlot)).m_41619_()) {
                this.inputItems.set(pSlot, (Object)pStack);
            } else {
                AlchemistCauldronTile.appendItem(this.inputItems, pStack);
            }
        }
    }
}

