/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import com.google.common.collect.ImmutableList;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.PotionRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;

public class AlchemistCauldronRecipeRegistry {
    private static final List<AlchemistCauldronRecipe> recipes = new ArrayList<AlchemistCauldronRecipe>();

    public static AlchemistCauldronRecipe addRecipe(AlchemistCauldronRecipe recipe) {
        recipes.add(recipe);
        return recipe;
    }

    public static ItemStack getOutput(ItemStack input, ItemStack ingredient, boolean consumeOnSucces) {
        if (input.m_41619_() || ingredient.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (AlchemistCauldronRecipe recipe : recipes) {
            ItemStack result = recipe.createOutput(input, ingredient, consumeOnSucces);
            if (result.m_41619_()) continue;
            return result;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isValidIngredient(ItemStack itemStack) {
        for (AlchemistCauldronRecipe recipe : recipes) {
            if (!ItemStack.m_150942_((ItemStack)recipe.getIngredient(), (ItemStack)itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOutput(ItemStack input, ItemStack ingredient) {
        return !AlchemistCauldronRecipeRegistry.getOutput(input, ingredient, false).m_41619_();
    }

    public static ImmutableList<AlchemistCauldronRecipe> getRecipes() {
        return ImmutableList.copyOf(recipes);
    }

    static {
        recipes.add(new AlchemistCauldronRecipe(Potions.f_43581_, Items.f_41837_, (Item)ItemRegistry.OAKSKIN_ELIXIR.get()).setBaseRequirement(2).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.OAKSKIN_ELIXIR.get(), Items.f_151049_, (Item)ItemRegistry.GREATER_OAKSKIN_ELIXIR.get()).setBaseRequirement(2).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe(Potions.f_43581_, Items.f_151049_, (Item)ItemRegistry.GREATER_HEALING_POTION.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe(Potions.f_43605_, (Item)ItemRegistry.SHRIVING_STONE.get(), (Item)ItemRegistry.INVISIBILITY_ELIXIR.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe(Potions.f_43606_, (Item)ItemRegistry.SHRIVING_STONE.get(), (Item)ItemRegistry.INVISIBILITY_ELIXIR.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.INVISIBILITY_ELIXIR.get(), Items.f_151086_, (Item)ItemRegistry.GREATER_INVISIBILITY_ELIXIR.get()));
        recipes.add(new AlchemistCauldronRecipe((Potion)PotionRegistry.INSTANT_MANA_THREE.get(), Items.f_42584_, (Item)ItemRegistry.EVASION_ELIXIR.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.EVASION_ELIXIR.get(), Items.f_42735_, (Item)ItemRegistry.GREATER_EVASION_ELIXIR.get()));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.INK_COMMON.get(), Items.f_151052_, (Item)ItemRegistry.INK_UNCOMMON.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.INK_UNCOMMON.get(), Items.f_42416_, (Item)ItemRegistry.INK_RARE.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.INK_RARE.get(), Items.f_42417_, (Item)ItemRegistry.INK_EPIC.get()).setBaseRequirement(4).setResultLimit(1));
        recipes.add(new AlchemistCauldronRecipe((Item)ItemRegistry.INK_EPIC.get(), Items.f_151049_, (Item)ItemRegistry.INK_LEGENDARY.get()).setBaseRequirement(4).setResultLimit(1));
    }
}

