/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.registry;

import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="irons_spellbooks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AttributeRegistry {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"irons_spellbooks");
    public static final RegistryObject<Attribute> MAX_MANA = ATTRIBUTES.register("max_mana", () -> new RangedAttribute("attribute.irons_spellbooks.max_mana", 100.0, 0.0, 10000.0).m_22084_(true));
    public static final RegistryObject<Attribute> MANA_REGEN = ATTRIBUTES.register("mana_regen", () -> new RangedAttribute("attribute.irons_spellbooks.mana_regen", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> COOLDOWN_REDUCTION = ATTRIBUTES.register("cooldown_reduction", () -> new RangedAttribute("attribute.irons_spellbooks.cooldown_reduction", 1.0, -10.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> SPELL_POWER = ATTRIBUTES.register("spell_power", () -> new RangedAttribute("attribute.irons_spellbooks.spell_power", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> SPELL_RESIST = ATTRIBUTES.register("spell_resist", () -> new RangedAttribute("attribute.irons_spellbooks.spell_resist", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> CAST_TIME_REDUCTION = ATTRIBUTES.register("cast_time_reduction", () -> new RangedAttribute("attribute.irons_spellbooks.cast_time_reduction", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> SUMMON_DAMAGE = ATTRIBUTES.register("summon_damage", () -> new RangedAttribute("attribute.irons_spellbooks.summon_damage", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> FIRE_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("fire");
    public static final RegistryObject<Attribute> ICE_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("ice");
    public static final RegistryObject<Attribute> LIGHTNING_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("lightning");
    public static final RegistryObject<Attribute> HOLY_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("holy");
    public static final RegistryObject<Attribute> ENDER_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("ender");
    public static final RegistryObject<Attribute> BLOOD_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("blood");
    public static final RegistryObject<Attribute> EVOCATION_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("evocation");
    public static final RegistryObject<Attribute> NATURE_MAGIC_RESIST = AttributeRegistry.newResistanceAttribute("nature");
    public static final RegistryObject<Attribute> FIRE_SPELL_POWER = AttributeRegistry.newPowerAttribute("fire");
    public static final RegistryObject<Attribute> ICE_SPELL_POWER = AttributeRegistry.newPowerAttribute("ice");
    public static final RegistryObject<Attribute> LIGHTNING_SPELL_POWER = AttributeRegistry.newPowerAttribute("lightning");
    public static final RegistryObject<Attribute> HOLY_SPELL_POWER = AttributeRegistry.newPowerAttribute("holy");
    public static final RegistryObject<Attribute> ENDER_SPELL_POWER = AttributeRegistry.newPowerAttribute("ender");
    public static final RegistryObject<Attribute> BLOOD_SPELL_POWER = AttributeRegistry.newPowerAttribute("blood");
    public static final RegistryObject<Attribute> EVOCATION_SPELL_POWER = AttributeRegistry.newPowerAttribute("evocation");
    public static final RegistryObject<Attribute> NATURE_SPELL_POWER = AttributeRegistry.newPowerAttribute("nature");

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(entity -> {
            e.add(entity, (Attribute)MAX_MANA.get());
            e.add(entity, (Attribute)MANA_REGEN.get());
            e.add(entity, (Attribute)SPELL_POWER.get());
            e.add(entity, (Attribute)SPELL_RESIST.get());
            e.add(entity, (Attribute)COOLDOWN_REDUCTION.get());
            e.add(entity, (Attribute)CAST_TIME_REDUCTION.get());
            e.add(entity, (Attribute)SUMMON_DAMAGE.get());
            e.add(entity, (Attribute)FIRE_MAGIC_RESIST.get());
            e.add(entity, (Attribute)ICE_MAGIC_RESIST.get());
            e.add(entity, (Attribute)LIGHTNING_MAGIC_RESIST.get());
            e.add(entity, (Attribute)HOLY_MAGIC_RESIST.get());
            e.add(entity, (Attribute)ENDER_MAGIC_RESIST.get());
            e.add(entity, (Attribute)BLOOD_MAGIC_RESIST.get());
            e.add(entity, (Attribute)EVOCATION_MAGIC_RESIST.get());
            e.add(entity, (Attribute)NATURE_MAGIC_RESIST.get());
            e.add(entity, (Attribute)FIRE_SPELL_POWER.get());
            e.add(entity, (Attribute)ICE_SPELL_POWER.get());
            e.add(entity, (Attribute)LIGHTNING_SPELL_POWER.get());
            e.add(entity, (Attribute)HOLY_SPELL_POWER.get());
            e.add(entity, (Attribute)ENDER_SPELL_POWER.get());
            e.add(entity, (Attribute)BLOOD_SPELL_POWER.get());
            e.add(entity, (Attribute)EVOCATION_SPELL_POWER.get());
            e.add(entity, (Attribute)NATURE_SPELL_POWER.get());
        });
    }

    private static RegistryObject<Attribute> newResistanceAttribute(String id) {
        return ATTRIBUTES.register(id + "_magic_resist", () -> new RangedAttribute("attribute.irons_spellbooks." + id + "_magic_resist", 1.0, 0.0, 10.0).m_22084_(true));
    }

    private static RegistryObject<Attribute> newPowerAttribute(String id) {
        return ATTRIBUTES.register(id + "_spell_power", () -> new RangedAttribute("attribute.irons_spellbooks." + id + "_spell_power", 1.0, 0.0, 10.0).m_22084_(true));
    }
}

