/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.magic;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicProvider;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class MagicData {
    private boolean isMob = false;
    private ServerPlayer serverPlayer = null;
    public static final String MANA = "mana";
    public static final String COOLDOWNS = "cooldowns";
    private float mana;
    private SyncedSpellData syncedSpellData;
    private int castingSpellLevel = 0;
    private int castDuration = 0;
    private int castDurationRemaining = 0;
    private CastSource castSource;
    private CastType castType;
    @Nullable
    private ICastData additionalCastData;
    private ItemStack castingItemStack = ItemStack.f_41583_;
    private final PlayerCooldowns playerCooldowns = new PlayerCooldowns();

    public MagicData(boolean isMob) {
        this.isMob = isMob;
    }

    public MagicData() {
        this(false);
    }

    public MagicData(ServerPlayer serverPlayer) {
        this(false);
        this.serverPlayer = serverPlayer;
    }

    public void setServerPlayer(ServerPlayer serverPlayer) {
        if (this.serverPlayer == null) {
            this.serverPlayer = serverPlayer;
        }
    }

    public int getMana() {
        return (int)this.mana;
    }

    public void setMana(float mana) {
        ChangeManaEvent e = new ChangeManaEvent((Player)this.serverPlayer, this, this.mana, mana);
        if (this.serverPlayer == null || !MinecraftForge.EVENT_BUS.post((Event)e)) {
            this.mana = e.getNewMana();
        }
    }

    public void addMana(float mana) {
        this.setMana(this.mana + mana);
    }

    public SyncedSpellData getSyncedData() {
        if (this.syncedSpellData == null) {
            this.syncedSpellData = new SyncedSpellData((LivingEntity)this.serverPlayer);
        }
        return this.syncedSpellData;
    }

    public void setSyncedData(SyncedSpellData syncedSpellData) {
        this.syncedSpellData = syncedSpellData;
    }

    public void resetCastingState() {
        this.castingSpellLevel = 0;
        this.castDuration = 0;
        this.castDurationRemaining = 0;
        this.castSource = CastSource.NONE;
        this.castType = CastType.NONE;
        this.getSyncedData().setIsCasting(false, "", 0);
        this.resetAdditionalCastData();
        if (this.serverPlayer != null) {
            this.serverPlayer.m_5810_();
        } else if (!this.isMob) {
            Minecraft.m_91087_().f_91074_.m_5810_();
        }
    }

    public void initiateCast(AbstractSpell spell, int spellLevel, int castDuration, CastSource castSource) {
        this.castingSpellLevel = spellLevel;
        this.castDuration = castDuration;
        this.castDurationRemaining = castDuration;
        this.castSource = castSource;
        this.castType = spell.getCastType();
        this.syncedSpellData.setIsCasting(true, spell.getSpellId(), spellLevel);
    }

    public ICastData getAdditionalCastData() {
        return this.additionalCastData;
    }

    public void setAdditionalCastData(ICastData newCastData) {
        this.additionalCastData = newCastData;
    }

    public void resetAdditionalCastData() {
        if (this.additionalCastData != null) {
            this.additionalCastData.reset();
            this.additionalCastData = null;
        }
    }

    public boolean isCasting() {
        return this.getSyncedData().isCasting();
    }

    public String getCastingSpellId() {
        return this.getSyncedData().getCastingSpellId();
    }

    public SpellData getCastingSpell() {
        return new SpellData(SpellRegistry.getSpell(this.getSyncedData().getCastingSpellId()), this.castingSpellLevel);
    }

    public int getCastingSpellLevel() {
        return this.castingSpellLevel;
    }

    public CastSource getCastSource() {
        if (this.castSource == null) {
            return CastSource.NONE;
        }
        return this.castSource;
    }

    public CastType getCastType() {
        return this.castType;
    }

    public float getCastCompletionPercent() {
        if (this.castDuration == 0) {
            return 1.0f;
        }
        return 1.0f - (float)this.castDurationRemaining / (float)this.castDuration;
    }

    public int getCastDurationRemaining() {
        return this.castDurationRemaining;
    }

    public int getCastDuration() {
        return this.castDuration;
    }

    public void handleCastDuration() {
        --this.castDurationRemaining;
        if (this.castDurationRemaining <= 0) {
            this.castDurationRemaining = 0;
        }
    }

    public void setPlayerCastingItem(ItemStack itemStack) {
        this.castingItemStack = itemStack;
    }

    public ItemStack getPlayerCastingItem() {
        return this.castingItemStack;
    }

    public PlayerCooldowns getPlayerCooldowns() {
        return this.playerCooldowns;
    }

    public static MagicData getPlayerMagicData(LivingEntity livingEntity) {
        if (livingEntity instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)livingEntity;
            return magicEntity.getMagicData();
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            LazyOptional capContainer = serverPlayer.getCapability(PlayerMagicProvider.PLAYER_MAGIC);
            if (capContainer.isPresent()) {
                Optional opt = capContainer.resolve();
                if (opt.isEmpty()) {
                    return new MagicData(serverPlayer);
                }
                MagicData pmd = (MagicData)opt.get();
                pmd.setServerPlayer(serverPlayer);
                return pmd;
            }
            return new MagicData(serverPlayer);
        }
        return new MagicData(null);
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128405_(MANA, (int)this.mana);
        if (this.playerCooldowns.hasCooldownsActive()) {
            ListTag listTag = new ListTag();
            this.playerCooldowns.saveNBTData(listTag);
            if (!listTag.isEmpty()) {
                compound.m_128365_(COOLDOWNS, (Tag)listTag);
            }
        }
        this.getSyncedData().saveNBTData(compound);
    }

    public void loadNBTData(CompoundTag compound) {
        this.mana = compound.m_128451_(MANA);
        ListTag listTag = (ListTag)compound.m_128423_(COOLDOWNS);
        if (listTag != null && !listTag.isEmpty()) {
            this.playerCooldowns.loadNBTData(listTag);
        }
        this.getSyncedData().loadNBTData(compound);
    }

    public String toString() {
        return String.format("isCasting:%s, spellID:%s], spellLevel:%s, duration:%s, durationRemaining:%s, source:%s, type:%s", new Object[]{this.getSyncedData().isCasting(), this.getSyncedData().getCastingSpellId(), this.castingSpellLevel, this.castDuration, this.castDurationRemaining, this.castSource, this.castType});
    }
}

