/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

@AutoSpellConfig
public class CounterspellSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "counterspell");
    public static final LazyOptional<List<MobEffect>> LAZY_MAGICAL_EFFECTS = LazyOptional.of(() -> List.of((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get(), (MobEffect)MobEffectRegistry.ASCENSION.get(), (MobEffect)MobEffectRegistry.ANGEL_WINGS.get(), (MobEffect)MobEffectRegistry.CHARGED.get(), (MobEffect)MobEffectRegistry.EVASION.get(), (MobEffect)MobEffectRegistry.HEARTSTOP.get(), (MobEffect)MobEffectRegistry.FORTIFY.get(), (MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), (MobEffect)MobEffectRegistry.FORTIFY.get(), (MobEffect)MobEffectRegistry.REND.get(), (MobEffect)MobEffectRegistry.SPIDER_ASPECT.get(), (MobEffect)MobEffectRegistry.BLIGHT.get(), (MobEffect)MobEffectRegistry.OAKSKIN.get()));
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(1).setCooldownSeconds(10.0).build();

    public CounterspellSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Vec3 start = entity.m_146892_();
        Vec3 end = start.m_82549_(entity.m_20156_().m_82541_().m_82490_(80.0));
        HitResult hitResult = Utils.raycastForEntity(entity.m_9236_(), (Entity)entity, start, end, true, 0.35f, Utils::validAntiMagicTarget);
        Vec3 forward = entity.m_20156_().m_82541_();
        if (hitResult instanceof EntityHitResult) {
            MagicSummon summon;
            AntiMagicSusceptible antiMagicSusceptible;
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            double distance = entity.m_20270_(entityHitResult.m_82443_());
            float i = 1.0f;
            while ((double)i < distance) {
                Vec3 pos = entity.m_146892_().m_82549_(forward.m_82490_((double)i));
                MagicManager.spawnParticles(world, (ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, false);
                i += 0.5f;
            }
            Entity entity2 = entityHitResult.m_82443_();
            if (entity2 instanceof AntiMagicSusceptible && (!((antiMagicSusceptible = (AntiMagicSusceptible)entity2) instanceof MagicSummon) || (summon = (MagicSummon)antiMagicSusceptible).getSummoner() != entity)) {
                antiMagicSusceptible.onAntiMagic(playerMagicData);
            } else {
                entity2 = entityHitResult.m_82443_();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    Utils.serverSideCancelCast(serverPlayer, true);
                } else {
                    entity2 = entityHitResult.m_82443_();
                    if (entity2 instanceof AbstractSpellCastingMob) {
                        AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)entity2;
                        abstractSpellCastingMob.cancelCast();
                    }
                }
            }
            Entity entity3 = entityHitResult.m_82443_();
            if (entity3 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity3;
                for (MobEffect mobEffect : (List)LAZY_MAGICAL_EFFECTS.resolve().get()) {
                    livingEntity.m_21195_(mobEffect);
                }
            }
        } else {
            for (float i = 1.0f; i < 40.0f; i += 0.5f) {
                Vec3 pos = entity.m_146892_().m_82549_(forward.m_82490_((double)i));
                MagicManager.spawnParticles(world, (ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, false);
                if (world.m_8055_(BlockPos.m_274446_((Position)pos)).m_60795_()) {
                    continue;
                }
                break;
            }
        }
        super.onCast(world, spellLevel, entity, playerMagicData);
    }
}

