/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.eldritch;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.eldritch_blast.EldritchBlastVisualEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.eldritch.AbstractEldritchSpell;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

@AutoSpellConfig
public class EldritchBlastSpell
extends AbstractEldritchSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "eldritch_blast");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(5).setCooldownSeconds(15.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation(this.getDamage(spellLevel, caster), 1)}), Component.m_237110_((String)"ui.irons_spellbooks.blast_count", (Object[])new Object[]{this.getEffectiveCastTime(spellLevel, caster) / 10}), Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation(EldritchBlastSpell.getRange(spellLevel, caster), 1)}));
    }

    public EldritchBlastSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 0;
        this.castTime = 30;
        this.baseManaCost = 25;
    }

    @Override
    public int getCastTime(int spellLevel) {
        return this.castTime + 10 * (spellLevel - 1);
    }

    @Override
    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAY_OF_FROST.get());
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Entity target;
        HitResult hitResult = Utils.raycastForEntity(level, (Entity)entity, EldritchBlastSpell.getRange(spellLevel, entity), true, 0.15f);
        level.m_7967_((Entity)new EldritchBlastVisualEntity(level, entity.m_146892_(), hitResult.m_82450_(), entity));
        if (hitResult.m_6662_() == HitResult.Type.ENTITY || hitResult.m_6662_() == HitResult.Type.BLOCK) {
            MagicManager.spawnParticles(level, ParticleHelper.ICY_FOG, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, 4, 0.0, 0.0, 0.0, 0.3, true);
        }
        if (hitResult.m_6662_() != HitResult.Type.ENTITY || !((target = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) || DamageSources.applyDamage(target, this.getDamage(spellLevel, entity), this.getDamageSource((Entity)entity), this.getSchoolType())) {
            // empty if block
        }
        MagicManager.spawnParticles(level, ParticleHelper.SNOWFLAKE, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, 50, 0.0, 0.0, 0.0, 0.3, false);
        super.onCast(level, spellLevel, entity, playerMagicData);
    }

    public static float getRange(int level, LivingEntity caster) {
        return 30.0f;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private int getFreezeTime(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 30.0f);
    }
}

