/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import java.util.List;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.compress.utils.Lists;

public class ClientRenderCache {
    public static List<Vec2> relativeSpellBarSlotLocations = Lists.newArrayList();
    public static final int[][] SPELL_LAYOUT = new int[][]{{1, 0, 0}, {2, 0, 0}, {2, 1, 0}, {2, 2, 0}, {3, 2, 0}, {3, 3, 0}, {4, 3, 0}, {4, 4, 0}, {3, 3, 3}, {3, 4, 3}, {4, 4, 3}, {4, 4, 4}, {4, 5, 4}, {5, 5, 4}, {5, 5, 5}};

    public static void generateRelativeLocations(SpellBookData spellBookData, int boxSize, int spriteSize) {
        relativeSpellBarSlotLocations.clear();
        if (spellBookData == null) {
            return;
        }
        int spellCount = spellBookData.getSpellSlots();
        int[] row1 = new int[SPELL_LAYOUT[spellCount - 1][0]];
        int[] row2 = new int[SPELL_LAYOUT[spellCount - 1][1]];
        int[] row3 = new int[SPELL_LAYOUT[spellCount - 1][2]];
        int[] rowWidth = new int[]{boxSize * row1.length, boxSize * row2.length, boxSize * row3.length};
        int[] rowHeight = new int[]{row1.length > 0 ? boxSize : 0, row2.length > 0 ? boxSize : 0, row3.length > 0 ? boxSize : 0};
        int[][] display = new int[][]{row1, row2, row3};
        int overallHeight = rowHeight[0] + rowHeight[1] + rowHeight[2];
        for (int row = 0; row < display.length; ++row) {
            for (int column = 0; column < display[row].length; ++column) {
                int offset = -rowWidth[row] / 2;
                Vec2 location = new Vec2((float)(offset + column * boxSize), (float)(row * boxSize - overallHeight / 2));
                location.m_165908_((float)(-spriteSize / 2));
                relativeSpellBarSlotLocations.add(location);
            }
        }
    }
}

