/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.loot.SpellFilter;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class AdditionalWanderingTrades {
    public static final int INK_SALE_PRICE_PER_RARITY = 4;
    public static final int INK_BUY_PRICE_PER_RARITY = 2;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addWanderingTrades(WandererTradesEvent event) {
        List<RandomCurioTrade> additionalGenericTrades = List.of(new RandomScrollTrade(new SpellFilter()), new RandomScrollTrade(new SpellFilter()), new RandomScrollTrade(new SpellFilter()), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_COMMON.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_UNCOMMON.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_RARE.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_EPIC.get())), new InkBuyTrade((InkItem)((Object)ItemRegistry.INK_LEGENDARY.get())), new RandomCurioTrade());
        List<ScrollPouchTrade> additionalRareTrades = List.of(SimpleTrade.of((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 64 - random.m_216332_(1, 8)), new ItemStack((ItemLike)Items.f_220224_, random.m_216332_(1, 3)), new ItemStack((ItemLike)ItemRegistry.LOST_KNOWLEDGE_FRAGMENT.get()), 8, 0, 0.05f)), new RandomCurioTrade(), new RandomCurioTrade(), new RandomCurioTrade(), new ScrollPouchTrade(), new ScrollPouchTrade());
        event.getGenericTrades().addAll(additionalGenericTrades);
        event.getRareTrades().addAll(additionalRareTrades);
    }

    static class RandomScrollTrade
    implements VillagerTrades.ItemListing {
        protected final ItemStack price;
        protected final ItemStack price2;
        protected final ItemStack forSale;
        protected final int maxTrades;
        protected final int xp;
        protected final float priceMult;
        protected final SpellFilter spellFilter;

        public RandomScrollTrade(SpellFilter spellFilter) {
            this.spellFilter = spellFilter;
            this.price = new ItemStack((ItemLike)Items.f_42616_);
            this.price2 = ItemStack.f_41583_;
            this.forSale = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            this.maxTrades = 1;
            this.xp = 5;
            this.priceMult = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity pTrader, RandomSource random) {
            AbstractSpell spell = this.spellFilter.getRandomSpell(random);
            int level = random.m_216332_(1, spell.getMaxLevel());
            SpellData.setSpellData(this.forSale, spell, level);
            this.price.m_41764_(spell.getRarity(level).getValue() * 5 + random.m_216332_(4, 7));
            return new MerchantOffer(this.price, this.price2, this.forSale, this.maxTrades, this.xp, this.priceMult);
        }
    }

    static class InkBuyTrade
    extends SimpleTrade {
        private InkBuyTrade(InkItem item) {
            super((Entity trader, RandomSource random) -> {
                boolean emeralds = random.m_188499_();
                return new MerchantOffer(new ItemStack((ItemLike)item), new ItemStack((ItemLike)(emeralds ? Items.f_42616_ : (ItemLike)ItemRegistry.ARCANE_ESSENCE.get()), 2 * item.getRarity().getValue() / (emeralds ? 1 : 2) + random.m_216332_(2, 3)), 8, 1, 0.05f);
            });
        }
    }

    static class RandomCurioTrade
    extends SimpleTrade {
        private RandomCurioTrade() {
            super((trader, random) -> {
                LootParams context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.f_19853_.f_46443_ && !(items = (loottable = trader.f_19853_.m_7654_().m_278653_().m_278676_(IronsSpellbooks.id("magic_items/basic_curios"))).m_287195_(context = new LootParams.Builder((ServerLevel)trader.f_19853_).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    ItemStack forSale = (ItemStack)items.get(0);
                    ItemStack cost = new ItemStack((ItemLike)Items.f_42616_, random.m_216332_(14, 25));
                    return new MerchantOffer(cost, forSale, 1, 5, 0.5f);
                }
                return null;
            });
        }
    }

    static class SimpleTrade
    implements VillagerTrades.ItemListing {
        final BiFunction<Entity, RandomSource, MerchantOffer> getOffer;

        private SimpleTrade(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            this.getOffer = getOffer;
        }

        public static SimpleTrade of(BiFunction<Entity, RandomSource, MerchantOffer> getOffer) {
            return new SimpleTrade(getOffer);
        }

        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            return this.getOffer.apply(pTrader, pRandom);
        }
    }

    static class ScrollPouchTrade
    extends SimpleTrade {
        private ScrollPouchTrade() {
            super((trader, random) -> {
                LootParams context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.f_19853_.f_46443_ && !(items = (loottable = trader.f_19853_.m_7654_().m_278653_().m_278676_(IronsSpellbooks.id("magic_items/scroll_pouch"))).m_287195_(context = new LootParams.Builder((ServerLevel)trader.f_19853_).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    int quality = 0;
                    ItemStack forSale = new ItemStack((ItemLike)Items.f_151058_).m_41714_((Component)Component.m_237115_((String)"item.irons_spellbooks.scroll_pouch"));
                    ListTag itemsTag = new ListTag();
                    for (ItemStack scroll : items) {
                        itemsTag.add((Object)scroll.m_41739_(new CompoundTag()));
                        quality += SpellData.getSpellData(scroll).getRarity().getValue() + 1;
                    }
                    forSale.m_41784_().m_128365_("Items", (Tag)itemsTag);
                    ItemStack cost = new ItemStack((ItemLike)Items.f_42616_, quality * 4 + random.m_216332_(8, 16));
                    return new MerchantOffer(cost, forSale, 1, 5, 0.5f);
                }
                return null;
            });
        }
    }

    static class ScrollMerchantOffer
    extends MerchantOffer {
        final SpellRarity scrollRarity;

        public ScrollMerchantOffer(SpellRarity scrollRarity, int emeralds, int pMaxUses, int pXp, float pPriceMultiplier) {
            super(new ItemStack((ItemLike)ItemRegistry.SCROLL.get()).m_41714_((Component)Component.m_237110_((String)"ui.irons_spellbooks.wandering_trader_scroll", (Object[])new Object[]{scrollRarity.getDisplayName()})), new ItemStack((ItemLike)Items.f_42616_, emeralds), pMaxUses, pXp, pPriceMultiplier);
            this.scrollRarity = scrollRarity;
        }

        public boolean m_45355_(ItemStack offerA, ItemStack offerB) {
            return offerA.m_150930_((Item)ItemRegistry.SCROLL.get()) && SpellData.getSpellData(offerA).getRarity() == this.scrollRarity && offerA.m_41613_() >= this.m_45358_().m_41613_() && this.m_45365_(offerB, this.m_45364_()) && offerB.m_41613_() >= this.m_45364_().m_41613_();
        }

        private boolean m_45365_(ItemStack pOffer, ItemStack pCost) {
            if (pCost.m_41619_() && pOffer.m_41619_()) {
                return true;
            }
            ItemStack itemstack = pOffer.m_41777_();
            if (itemstack.m_41720_().isDamageable(itemstack)) {
                itemstack.m_41721_(itemstack.m_41773_());
            }
            return ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)pCost) && (!pCost.m_41782_() || itemstack.m_41782_() && NbtUtils.m_129235_((Tag)pCost.m_41783_(), (Tag)itemstack.m_41783_(), (boolean)false));
        }

        static VillagerTrades.ItemListing createListing(final SpellRarity scrollRarity, final int emeralds, final int pMaxUses, final int pXp, final float pPriceMultiplier) {
            return new VillagerTrades.ItemListing(){

                @Nullable
                public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
                    return new ScrollMerchantOffer(scrollRarity, emeralds, pMaxUses, pXp, pPriceMultiplier);
                }
            };
        }
    }

    static class InkSellTrade
    extends SimpleTrade {
        private InkSellTrade(InkItem item) {
            super((Entity trader, RandomSource random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4 * item.getRarity().getValue() + random.m_216332_(2, 3)), new ItemStack((ItemLike)item), 4, 1, 0.05f));
        }
    }
}

