/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundUpdateCastingState {
    private final String spellId;
    private final int spellLevel;
    private final int castTime;
    private final CastSource castSource;

    public ClientboundUpdateCastingState(String spellId, int spellLevel, int castTime, CastSource castSource) {
        this.spellId = spellId;
        this.spellLevel = spellLevel;
        this.castTime = castTime;
        this.castSource = castSource;
    }

    public ClientboundUpdateCastingState(FriendlyByteBuf buf) {
        this.spellId = buf.m_130277_();
        this.spellLevel = buf.readInt();
        this.castTime = buf.readInt();
        this.castSource = (CastSource)buf.m_130066_(CastSource.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.spellId);
        buf.writeInt(this.spellLevel);
        buf.writeInt(this.castTime);
        buf.m_130068_((Enum)this.castSource);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientMagicData.setClientCastState(this.spellId, this.spellLevel, this.castTime, this.castSource));
        return true;
    }
}

