/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.weapons.AutoloaderCrossbow;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public class ItemRendererMixin {
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="HEAD")})
    public void renderSpellbookCooldown(Font p_281721_, ItemStack stack, int one, int two, CallbackInfo ci) {
        Item item = stack.m_41720_();
        if (item instanceof SpellBook) {
            AbstractSpell spell = SpellBookData.getSpellBookData(stack).getActiveSpell().getSpell();
            float f = spell == SpellRegistry.none() ? 0.0f : ClientMagicData.getCooldownPercent(spell);
            this.renderSpellCooldown(one, two, f);
        } else if (SpellData.hasSpellData(stack) && !stack.m_41720_().equals(ItemRegistry.SCROLL.get())) {
            AbstractSpell spell = SpellData.getSpellData(stack).getSpell();
            float f = spell == SpellRegistry.none() ? 0.0f : ClientMagicData.getCooldownPercent(spell);
            this.renderSpellCooldown(one, two, f);
        } else if (item instanceof AutoloaderCrossbow) {
            this.renderSpellCooldown(one, two, !AutoloaderCrossbow.isLoading(stack) ? 0.0f : 1.0f - (float)AutoloaderCrossbow.getLoadingTicks(stack) / (float)AutoloaderCrossbow.m_40939_(stack));
        }
    }

    private void renderSpellCooldown(int one, int two, float f) {
        if (f > 0.0f) {
            GuiGraphics self = (GuiGraphics)this;
            int i1 = two + Mth.m_14143_((float)(16.0f * (1.0f - f)));
            int j1 = i1 + Mth.m_14167_((float)(16.0f * f));
            self.m_285944_(RenderType.m_286086_(), one, i1, one + 16, j1, Integer.MAX_VALUE);
        }
    }
}

