/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.item.ISpellbook;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellBook
extends Item
implements ISpellbook {
    protected final SpellRarity rarity;
    protected final int spellSlots;

    public SpellBook() {
        this(1, SpellRarity.COMMON);
    }

    public SpellBook(int spellSlots, SpellRarity rarity) {
        this(spellSlots, rarity, ItemPropertiesHelper.equipment().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public SpellBook(int spellSlots, SpellRarity rarity, Item.Properties pProperties) {
        super(pProperties);
        this.spellSlots = spellSlots;
        this.rarity = rarity;
    }

    public SpellRarity getRarity() {
        return this.rarity;
    }

    public int getSpellSlots() {
        return this.spellSlots;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        SpellBookData spellBookData = SpellBookData.getSpellBookData(itemStack);
        SpellData spellData = spellBookData.getActiveSpell();
        if (spellData.equals(SpellData.EMPTY)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.m_5776_()) {
            if (ClientMagicData.isCasting()) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellData.getLevel(), (LivingEntity)player) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        if (spellData.getSpell().attemptInitiateCast(itemStack, spellData.getLevel(), level, player, CastSource.SPELLBOOK, true)) {
            if (spellData.getSpell().getCastType().holdToCast()) {
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public int m_8105_(ItemStack itemStack) {
        return 7200;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_5551_(ItemStack itemStack, Level p_41413_, LivingEntity entity, int p_41415_) {
        IronsSpellbooks.LOGGER.debug("Spellbook Release Using ticks used: {}", (Object)p_41415_);
        entity.m_5810_();
        Utils.releaseUsingHelper(entity, itemStack, p_41415_);
        super.m_5551_(itemStack, p_41413_, entity, p_41415_);
    }

    public boolean isUnique() {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        if (!this.isUnique()) {
            lines.add((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.spellbook_rarity", (Object[])new Object[]{this.rarity.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
        } else {
            lines.add((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.spellbook_rarity", (Object[])new Object[]{Component.m_237115_((String)"tooltip.irons_spellbooks.spellbook_unique").m_130948_(Style.f_131099_.m_178520_(14697252))}).m_130940_(ChatFormatting.GRAY));
        }
        lines.add((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.spellbook_spell_count", (Object[])new Object[]{this.spellSlots}).m_130940_(ChatFormatting.GRAY));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !SpellBookData.getSpellBookData(itemStack).getActiveSpell().equals(SpellData.EMPTY)) {
            lines.addAll(TooltipsUtils.formatActiveSpellTooltip(itemStack, CastSource.SPELLBOOK, player));
        }
        super.m_7373_(itemStack, level, lines, flag);
    }
}

