/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ExtendedWitherSkull
extends WitherSkull
implements AntiMagicSusceptible {
    protected float damage;

    public ExtendedWitherSkull(EntityType<? extends WitherSkull> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ExtendedWitherSkull(LivingEntity shooter, Level level, float speed, float damage) {
        super((EntityType)EntityRegistry.WITHER_SKULL_PROJECTILE.get(), level);
        this.m_5602_((Entity)shooter);
        Vec3 power = shooter.m_20154_().m_82541_().m_82490_((double)speed);
        this.f_36813_ = power.f_82479_;
        this.f_36814_ = power.f_82480_;
        this.f_36815_ = power.f_82481_;
        this.damage = damage;
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.m_9236_().f_46443_) {
            float explosionRadius = 2.0f;
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius));
            for (Entity entity : entities) {
                double distance = entity.m_20238_(hitResult.m_82450_());
                if (!(distance < (double)(explosionRadius * explosionRadius)) || !this.m_5603_(entity)) continue;
                float damage = (float)((double)this.damage * (1.0 - distance / (double)(explosionRadius * explosionRadius)));
                AbstractSpell spell = (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get();
                DamageSources.applyDamage(entity, damage, spell.getDamageSource((Entity)this, this.m_19749_()), spell.getSchoolType());
            }
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, false, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void onAntiMagic(MagicData playerMagicData) {
        this.m_146870_();
    }
}

