/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob;

import com.google.common.collect.Maps;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractSpellCastingMob
extends PathfinderMob
implements GeoEntity,
IMagicEntity {
    public static final ResourceLocation modelResource = new ResourceLocation("irons_spellbooks", "geo/abstract_casting_mob.geo.json");
    public static final ResourceLocation textureResource = new ResourceLocation("irons_spellbooks", "textures/entity/abstract_casting_mob/abstract_casting_mob.png");
    public static final ResourceLocation animationInstantCast = new ResourceLocation("irons_spellbooks", "animations/casting_animations.json");
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.m_135353_(AbstractSpellCastingMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.m_135353_(AbstractSpellCastingMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final MagicData playerMagicData = new MagicData(true);
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
    @javax.annotation.Nullable
    private SpellData castingSpell;
    private final HashMap<String, AbstractSpell> spells = Maps.newHashMap();
    private int drinkTime;
    public boolean hasUsedSingleAttack;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private AbstractSpell lastCastSpellType = SpellRegistry.none();
    private AbstractSpell instantCastSpellType = SpellRegistry.none();
    private boolean cancelCastAnimation = false;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("blank");
    private final AnimationController animationControllerOtherCast = new AnimationController((GeoAnimatable)this, "other_casting", 0, this::otherCastingPredicate);
    private final AnimationController animationControllerInstantCast = new AnimationController((GeoAnimatable)this, "instant_casting", 0, this::instantCastingPredicate);
    private final AnimationController animationControllerLongCast = new AnimationController((GeoAnimatable)this, "long_casting", 0, this::longCastingPredicate);

    protected AbstractSpellCastingMob(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
    }

    @Override
    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CANCEL_CAST, (Object)false);
        this.f_19804_.m_135372_(DATA_DRINKING_POTION, (Object)false);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DRINKING_POTION);
    }

    protected void setDrinkingPotion(boolean drinkingPotion) {
        this.f_19804_.m_135381_(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public void startDrinkingPotion() {
        if (!this.f_19853_.f_46443_) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
            attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.m_5634_(Math.min(10.0f, this.m_21233_() / 4.0f));
        this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (!this.f_19853_.f_46443_) {
            return;
        }
        if (pKey.m_135015_() == DATA_CANCEL_CAST.m_135015_()) {
            this.cancelCast();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound);
        pCompound.m_128379_("usedSpecial", this.hasUsedSingleAttack);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound);
        if (syncedSpellData.isCasting()) {
            AbstractSpell spell = SpellRegistry.getSpell(syncedSpellData.getCastingSpellId());
            this.initiateCastSpell(spell, syncedSpellData.getCastingSpellLevel());
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.m_128471_("usedSpecial");
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (this.f_19853_.f_46443_) {
                this.cancelCastAnimation = true;
            } else {
                this.f_19804_.m_135381_(DATA_CANCEL_CAST, (Object)((Boolean)this.f_19804_.m_135370_(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    private void castComplete() {
        if (!this.f_19853_.f_46443_) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void startAutoSpinAttack(int pAttackTicks) {
        this.f_20938_ = pAttackTicks;
        if (!this.f_19853_.f_46443_) {
            this.m_21155_(4, true);
        }
        this.m_146922_((float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 57.2957763671875));
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        boolean isCasting = this.playerMagicData.isCasting();
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.castingSpell = this.playerMagicData.getCastingSpell();
        if (this.castingSpell == null) {
            return;
        }
        if (!this.playerMagicData.isCasting() && isCasting) {
            this.castComplete();
        } else if (this.playerMagicData.isCasting() && !isCasting) {
            AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
            this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
            if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpell();
                this.castingSpell.getSpell().onClientPreCast(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                this.castComplete();
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isDrinkingPotion()) {
            if (this.drinkTime-- <= 0) {
                this.finishDrinkingPotion();
            } else if (this.drinkTime % 4 == 0 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11911_, this.m_5720_(), 1.0f, Utils.random.m_188501_() * 0.1f + 0.9f);
            }
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.getSpell().onServerCastTick(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
        this.forceLookAtTarget(this.m_5448_());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.castingSpell.getSpell().onCast(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.getSpell().onCast(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
            return;
        }
        if (this.f_19853_.f_46443_) {
            this.cancelCastAnimation = false;
        }
        this.castingSpell = new SpellData(spell, spellLevel);
        if (this.m_5448_() != null) {
            this.forceLookAtTarget(this.m_5448_());
        }
        if (!this.f_19853_.f_46443_ && !this.castingSpell.getSpell().checkPreCastConditions(this.f_19853_, spellLevel, (LivingEntity)this, this.playerMagicData)) {
            this.castingSpell = null;
            return;
        }
        if (spell == SpellRegistry.TELEPORT_SPELL.get() || spell == SpellRegistry.FROST_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(10);
        } else if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(3);
        } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
            this.setBurningDashDirectionData();
        }
        this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB);
        if (!this.f_19853_.f_46443_) {
            this.castingSpell.getSpell().onServerPreCast(this.f_19853_, this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.m_5448_();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.m_20154_().m_82541_().m_82490_((double)(-distance));
            Vec3 pos = target.m_20182_();
            Vec3 teleportPos = rotation.m_82549_(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3(0.15f * (float)i).m_82542_(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel(this.f_19853_, target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180))).m_82549_(randomness), 5);
                teleportPos = new Vec3(teleportPos.f_82479_, teleportPos.f_82480_ + (double)0.1f, teleportPos.f_82481_);
                AABB reposBB = this.m_20191_().m_82383_(teleportPos.m_82546_(this.m_20182_()));
                IronsSpellbooks.LOGGER.debug("setTeleportLocationBehindTarget attempt to teleport to {}:", (Object)reposBB.m_82399_());
                if (!this.f_19853_.m_186437_((Entity)this, reposBB.m_82400_((double)-0.05f))) {
                    valid = true;
                    break;
                }
                IronsSpellbooks.LOGGER.debug("fail");
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(this.m_20182_()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(this.m_20182_()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData(new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d1 = target.m_20188_() - this.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            this.m_146926_(f1 % 360.0f);
            this.m_146922_(f % 360.0f);
        }
    }

    private void addClientSideParticles() {
        double d0 = 0.4;
        double d1 = 0.3;
        double d2 = 0.35;
        float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnim(@Nullable String controllerName, String animName) {
        super.triggerAnim(controllerName, animName);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.animationControllerOtherCast});
        controllerRegistrar.add(new AnimationController[]{this.animationControllerInstantCast});
        controllerRegistrar.add(new AnimationController[]{this.animationControllerLongCast});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate)});
    }

    private PlayState idlePredicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.STOP;
    }

    private PlayState instantCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.instantCastSpellType != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.instantCastSpellType);
            this.instantCastSpellType = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    private PlayState longCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation || !this.isCasting()) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.isCasting() && this.castingSpell != null && this.castingSpell.getSpell().getCastType() == CastType.LONG && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.castingSpell.getSpell());
        }
        if (!this.isCasting() && this.lastCastSpellType.getCastType() == CastType.LONG) {
            this.setFinishAnimationFromSpell(controller, this.lastCastSpellType);
        }
        return PlayState.CONTINUE;
    }

    private PlayState otherCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.isCasting() && this.castingSpell != null && controller.getAnimationState() == AnimationController.State.STOPPED) {
            if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS) {
                this.setStartAnimationFromSpell(controller, this.castingSpell.getSpell());
            }
            return PlayState.CONTINUE;
        }
        if (this.isCasting()) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private void setStartAnimationFromSpell(AnimationController controller, AbstractSpell spell) {
        spell.getCastStartAnimation().getForMob().ifPresentOrElse(animationBuilder -> {
            controller.forceAnimationReset();
            controller.setAnimation(animationBuilder);
            this.lastCastSpellType = spell;
            this.cancelCastAnimation = false;
        }, () -> {
            this.cancelCastAnimation = true;
        });
    }

    private void setFinishAnimationFromSpell(AnimationController controller, AbstractSpell spell) {
        if (spell.getCastFinishAnimation() == AnimationHolder.pass()) {
            return;
        }
        spell.getCastFinishAnimation().getForMob().ifPresentOrElse(animationBuilder -> {
            controller.forceAnimationReset();
            controller.setAnimation(animationBuilder);
            this.lastCastSpellType = SpellRegistry.none();
            this.cancelCastAnimation = false;
        }, () -> {
            this.cancelCastAnimation = true;
        });
    }

    public boolean isAnimating() {
        return this.isCasting() || this.animationControllerOtherCast.getAnimationState() != AnimationController.State.STOPPED || this.animationControllerInstantCast.getAnimationState() != AnimationController.State.STOPPED;
    }

    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public boolean shouldAlwaysAnimateHead() {
        return true;
    }

    public boolean shouldAlwaysAnimateLegs() {
        return true;
    }

    public boolean shouldPointArmsWhileCasting() {
        return true;
    }
}

