/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datafix.fixers;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.datafix.DataFixerElement;
import io.redspace.ironsspellbooks.datafix.DataFixerHelpers;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class FixIsbSpellbook
extends DataFixerElement {
    @Override
    public List<String> preScanValuesToMatch() {
        return List.of("ISB_spellbook");
    }

    @Override
    public boolean runFixer(CompoundTag tag) {
        ListTag listTagSpells;
        CompoundTag spellBookTag;
        if (tag != null && (spellBookTag = (CompoundTag)tag.m_128423_("ISB_spellbook")) != null && (listTagSpells = (ListTag)spellBookTag.m_128423_("spells")) != null && !listTagSpells.isEmpty()) {
            boolean fixed = false;
            if (((CompoundTag)listTagSpells.get(0)).m_128441_("id")) {
                this.fixSpellbookData(listTagSpells);
                fixed = true;
            }
            if (this.fixSpellbookSpellIds(listTagSpells)) {
                fixed = true;
            }
            return fixed;
        }
        return false;
    }

    private void fixSpellbookData(ListTag listTag) {
        listTag.forEach(tag -> {
            CompoundTag t = (CompoundTag)tag;
            int legacySpellId = t.m_128451_("id");
            t.m_128359_("sid", DataFixerHelpers.LEGACY_SPELL_MAPPING.getOrDefault(legacySpellId, "irons_spellbooks:none"));
            t.m_128473_("id");
        });
    }

    private boolean fixSpellbookSpellIds(ListTag listTagSpells) {
        IronsSpellbooks.LOGGER.debug("fixSpellbookSpellIds: {}", (Object)listTagSpells);
        AtomicBoolean fixed = new AtomicBoolean(false);
        listTagSpells.forEach(tag -> {
            String newName;
            CompoundTag spellTag = (CompoundTag)tag;
            if (spellTag.m_128441_("sid") && (newName = DataFixerHelpers.NEW_SPELL_IDS.get(spellTag.m_128423_("sid").m_7916_())) != null) {
                spellTag.m_128359_("sid", newName);
                fixed.set(true);
            }
        });
        return fixed.get();
    }
}

