/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.api.magic.IMagicManager;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.network.ClientboundSyncCooldown;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.setup.Messages;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MagicManager
implements IMagicManager {
    public static final int MANA_REGEN_TICKS = 10;
    public static final int CONTINUOUS_CAST_TICK_INTERVAL = 10;

    @Override
    @Deprecated
    public void setPlayerCurrentMana(ServerPlayer serverPlayer, int newManaValue) {
        MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        playerMagicData.setMana(newManaValue);
    }

    public void regenPlayerMana(ServerPlayer serverPlayer, MagicData playerMagicData) {
        int playerMaxMana = (int)serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get());
        float playerManaRegenMultiplier = (float)serverPlayer.m_21133_((Attribute)AttributeRegistry.MANA_REGEN.get());
        float increment = Math.max((float)playerMaxMana * playerManaRegenMultiplier * 0.01f, 1.0f);
        if (playerMagicData.getMana() != playerMaxMana) {
            if ((float)playerMagicData.getMana() + increment < (float)playerMaxMana) {
                playerMagicData.addMana(increment);
            } else {
                playerMagicData.setMana(playerMaxMana);
            }
        }
    }

    public void tick(Level level) {
        boolean doManaRegen = level.m_7654_().m_129921_() % 10 == 0;
        level.m_6907_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                playerMagicData.getPlayerCooldowns().tick(1);
                if (playerMagicData.isCasting()) {
                    playerMagicData.handleCastDuration();
                    AbstractSpell spell = SpellRegistry.getSpell(playerMagicData.getCastingSpellId());
                    if (spell.getCastType() == CastType.LONG && !serverPlayer.m_6117_()) {
                        if (playerMagicData.getCastDurationRemaining() <= 0) {
                            spell.castSpell(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), serverPlayer, playerMagicData.getCastSource(), true);
                            spell.onServerCastComplete(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), (LivingEntity)serverPlayer, playerMagicData, false);
                            Scroll.attemptRemoveScrollAfterCast(serverPlayer);
                        }
                    } else if (spell.getCastType() == CastType.CONTINUOUS && (playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
                        if (playerMagicData.getCastDurationRemaining() < 10 || playerMagicData.getCastSource().consumesMana() && playerMagicData.getMana() - spell.getManaCost(playerMagicData.getCastingSpellLevel(), null) * 2 < 0) {
                            spell.castSpell(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), serverPlayer, playerMagicData.getCastSource(), true);
                            if (playerMagicData.getCastSource() == CastSource.SCROLL) {
                                Scroll.attemptRemoveScrollAfterCast(serverPlayer);
                            }
                            spell.onServerCastComplete(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), (LivingEntity)serverPlayer, playerMagicData, false);
                        } else {
                            spell.castSpell(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), serverPlayer, playerMagicData.getCastSource(), false);
                        }
                    }
                    if (playerMagicData.isCasting()) {
                        spell.onServerCastTick(serverPlayer.f_19853_, playerMagicData.getCastingSpellLevel(), (LivingEntity)serverPlayer, playerMagicData);
                    }
                }
                if (doManaRegen) {
                    this.regenPlayerMana(serverPlayer, playerMagicData);
                    Messages.sendToPlayer(new ClientboundSyncMana(playerMagicData), serverPlayer);
                }
            }
        });
    }

    @Override
    public void addCooldown(ServerPlayer serverPlayer, AbstractSpell spell, CastSource castSource) {
        if (castSource == CastSource.SCROLL) {
            return;
        }
        int effectiveCooldown = MagicManager.getEffectiveSpellCooldown(spell, (Player)serverPlayer, castSource);
        MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerCooldowns().addCooldown(spell, effectiveCooldown);
        Messages.sendToPlayer(new ClientboundSyncCooldown(spell.getSpellId(), effectiveCooldown), serverPlayer);
    }

    public static int getEffectiveSpellCooldown(AbstractSpell spell, Player player, CastSource castSource) {
        double playerCooldownModifier = player.m_21133_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get());
        float itemCoolDownModifer = 1.0f;
        if (castSource == CastSource.SWORD) {
            itemCoolDownModifer = ((Double)ServerConfigs.SWORDS_CD_MULTIPLIER.get()).floatValue();
        }
        return (int)((double)spell.getSpellCooldown() * (2.0 - Utils.softCapFormula(playerCooldownModifier)) * (double)itemCoolDownModifer);
    }

    public static void spawnParticles(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        level.m_7654_().m_6846_().m_11314_().forEach(player -> ((ServerLevel)level).m_8624_(player, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed));
    }
}

