/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AnimationHolder {
    private final RawAnimation geckoAnimation;
    private final ResourceLocation playerAnimation;
    public final boolean isPass;
    private static final AnimationHolder empty = new AnimationHolder(false);
    private static final AnimationHolder pass = new AnimationHolder(true);

    public AnimationHolder(String path, Animation.LoopType loopType) {
        this.playerAnimation = IronsSpellbooks.id(path);
        this.geckoAnimation = RawAnimation.begin().then(this.playerAnimation.m_135815_(), loopType);
        this.isPass = false;
    }

    private AnimationHolder(boolean isPass) {
        this.playerAnimation = null;
        this.geckoAnimation = null;
        this.isPass = isPass;
    }

    public static AnimationHolder none() {
        return empty;
    }

    public static AnimationHolder pass() {
        return pass;
    }

    public Optional<RawAnimation> getForMob() {
        return this.geckoAnimation == null ? Optional.empty() : Optional.of(this.geckoAnimation);
    }

    public Optional<ResourceLocation> getForPlayer() {
        return this.playerAnimation == null ? Optional.empty() : Optional.of(this.playerAnimation);
    }
}

