/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.magic;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class LearnedSpellData {
    public static final String LEARNED_SPELLS = "learnedSpells";
    public final Set<ResourceLocation> learnedSpells = new HashSet<ResourceLocation>();

    public void saveToNBT(CompoundTag compound) {
        if (!this.learnedSpells.isEmpty()) {
            ListTag listTag = new ListTag();
            for (ResourceLocation resourceLocation : this.learnedSpells) {
                listTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
            }
            compound.m_128365_(LEARNED_SPELLS, (Tag)listTag);
        }
    }

    public void loadFromNBT(CompoundTag compound) {
        ListTag learnedTag = (ListTag)compound.m_128423_(LEARNED_SPELLS);
        if (learnedTag != null && !learnedTag.isEmpty()) {
            for (Tag tag : learnedTag) {
                if (!(tag instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)tag;
                ResourceLocation resourceLocation = new ResourceLocation(stringTag.m_7916_());
                if (SpellRegistry.REGISTRY.get().getValue(resourceLocation) == null) continue;
                this.learnedSpells.add(resourceLocation);
            }
        }
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.learnedSpells.size());
        for (ResourceLocation resourceLocation : this.learnedSpells) {
            buf.m_130070_(resourceLocation.toString());
        }
    }

    public void readFromBuffer(FriendlyByteBuf buf) {
        int i = buf.readInt();
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                ResourceLocation resourceLocation = new ResourceLocation(buf.m_130277_());
                if (SpellRegistry.REGISTRY.get().getValue(resourceLocation) == null) continue;
                this.learnedSpells.add(resourceLocation);
            }
        }
    }
}

