/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.config;

import crystalspider.harvestwithease.config.AreaSize;
import crystalspider.harvestwithease.config.AreaStep;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.TierSortingRegistry;

public class ModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonConfig COMMON = new CommonConfig(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public static List<? extends String> getCrops() {
        return (List)ModConfig.COMMON.crops.get();
    }

    public static Boolean getRequireHoe() {
        return (Boolean)ModConfig.COMMON.requireHoe.get();
    }

    public static Integer getDamageOnHarvest() {
        return (Integer)ModConfig.COMMON.damageOnHarvest.get();
    }

    public static Integer getGrantedExp() {
        return (Integer)ModConfig.COMMON.grantedExp.get();
    }

    public static Boolean getPlaySound() {
        return (Boolean)ModConfig.COMMON.playSound.get();
    }

    public static String getMultiHarvestStartingTier() {
        return (String)ModConfig.COMMON.multiHarvestStartingTier.get();
    }

    public static AreaSize getAreaStartingSize() {
        return (AreaSize)((Object)ModConfig.COMMON.areaStartingSize.get());
    }

    public static AreaStep getAreaIncrementStep() {
        return (AreaStep)((Object)ModConfig.COMMON.areaIncrementStep.get());
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> crops;
        private final ForgeConfigSpec.BooleanValue requireHoe;
        private final ForgeConfigSpec.IntValue damageOnHarvest;
        private final ForgeConfigSpec.IntValue grantedExp;
        private final ForgeConfigSpec.BooleanValue playSound;
        private final ForgeConfigSpec.ConfigValue<String> multiHarvestStartingTier;
        private final ForgeConfigSpec.EnumValue<AreaSize> areaStartingSize;
        private final ForgeConfigSpec.EnumValue<AreaStep> areaIncrementStep;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.crops = builder.comment("List of in-game IDs of additional crops").defineListAllowEmpty(List.of("crops"), Collections::emptyList, element -> element instanceof String && !((String)element).isBlank());
            this.requireHoe = builder.comment("Require holding a hoe (either hands) to right-click harvest").define("require hoe", false);
            this.damageOnHarvest = builder.comment("If [require hoe] is set to true, damage the hoe of the given amount (0 to disable, must be an integer)").defineInRange("damage on harvest", 0, 0, Integer.MAX_VALUE);
            this.grantedExp = builder.comment("Amount of experience to grant on harvest (0 to disable, must be an integer).").defineInRange("exp on harvest", 0, 0, Integer.MAX_VALUE);
            this.playSound = builder.comment("Play a sound when harvesting a crop.").define("play sound", true);
            this.multiHarvestStartingTier = builder.comment(new String[]{"Tool tier starting from which it is possible to harvest multiple crops at once.", "All tiers that cannot multi-harvest will have a 1x1 square area of effect (a single crop).", "If [starting harvest area size] is set to \"" + AreaSize.SINGLE + "\" and [area increment step] to \"" + AreaStep.NONE + "\" multi-harvest will be effectively disabled, regardless of this config option value.", "From lesser to greater, Vanilla tiers are: " + String.join((CharSequence)", ", (CharSequence[])Stream.of(Tiers.values()).sorted((t1, t2) -> t1.m_6604_() - t2.m_6604_()).map(tier -> "\"" + tier.toString().toLowerCase() + "\"").toArray(String[]::new)) + ".", "Be aware that other mods may add other tiers and/or removing existing ones. Only the actual tiers available at runtime are allowed here.", "When set to \"none\", the only value not in the tiers list, multi-harvest will be enabled without a tool too. Note that [require hoe] takes precedence.", "The value in this config option can either be the name of the tier, e.g. \"iron\", or the id of the tier, e.g. \"minecraft:iron\"."}).define("multi-harvest starting tier", (Object)Tiers.WOOD.toString().toLowerCase(), value -> {
                String string;
                return value instanceof String && ((string = (String)value).equalsIgnoreCase("none") || TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(string.toLowerCase())) != null);
            });
            this.areaStartingSize = builder.comment(this.getAreaSizeComments()).defineEnum("starting harvest area size", (Enum)AreaSize.SINGLE, (Enum[])AreaSize.values());
            this.areaIncrementStep = builder.comment(this.getAreaStepComments()).defineEnum("area increment step", (Enum)AreaStep.NONE, (Enum[])AreaStep.values());
        }

        private String[] getAreaSizeComments() {
            AreaSize[] sizes = AreaSize.values();
            String[] comments = new String[3 + sizes.length];
            comments[0] = "Starting multi-harvest area size (square side length).";
            comments[1] = "The area is always a square centered on the right-clicked crop.";
            comments[2] = "Setting this to \"" + AreaSize.SINGLE + "\" and [area increment step] to \"" + AreaStep.NONE + "\" will effectively disable multi-harvest.";
            for (int i = 0; i < sizes.length; ++i) {
                comments[i + 3] = "\"" + sizes[i] + "\" - " + sizes[i] + " harvest area size, a " + sizes[i].size + "x" + sizes[i].size + " square.";
            }
            return comments;
        }

        private String[] getAreaStepComments() {
            AreaStep[] steps = AreaStep.values();
            String[] comments = new String[2 + steps.length];
            comments[0] = "Increment step for the harvest area size with higher tool tiers.";
            comments[1] = "Setting this to \"" + AreaStep.NONE + "\" and [starting harvest area size] to \"" + AreaSize.SINGLE + "\" will effectively disable multi-harvest.";
            comments[2] = "\"" + steps[0] + "\" - no increment, the area stays the same (as defined by [starting harvest area size]) regardless of the tool used, if any.";
            for (int i = 1; i < steps.length; ++i) {
                comments[i + 2] = "\"" + steps[i] + "\" - " + steps[i] + " increment, the size of the area, starting from [starting harvest area size], increases by " + steps[i].step + " with each higher tier. E.g. 1x1 -> " + (1 + steps[i].step) + "x" + (1 + steps[i].step) + " -> " + (1 + steps[i].step * 2) + "x" + (1 + steps[i].step * 2) + " -> ...";
            }
            return comments;
        }
    }
}

