/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.forge.GTUtilImpl;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;

public class GTUtil {
    @Nullable
    public static Direction determineWrenchingSide(Direction facing, float x, float y, float z) {
        Direction opposite = facing.m_122424_();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)z < 0.25) {
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    return Direction.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.SOUTH;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
        }
        return null;
    }

    public static float getExplosionPower(long voltage) {
        return GTUtil.getTierByVoltage(voltage) + 1;
    }

    public static int nearestLesserOrEqual(@Nonnull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] <= value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static int nearestLesser(@Nonnull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] < value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static byte getTierByVoltage(long voltage) {
        return (byte)Math.min(14, GTUtil.nearestLesser(GTValues.V, voltage) + 1);
    }

    public static byte getFloorTierByVoltage(long voltage) {
        return (byte)Math.max(0, GTUtil.nearestLesserOrEqual(GTValues.V, voltage));
    }

    public static ItemStack copy(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            return stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack copyAmount(int amount, ItemStack ... stacks) {
        ItemStack stack = GTUtil.copy(stacks);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.m_41764_(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        FluidStack stack = fluidStack.copy();
        stack.setAmount((long)amount);
        return stack;
    }

    public static <M> M selectItemInList(int index, M replacement, List<M> list, Class<M> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (maybeResult != null) {
            return maybeResult;
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static <T> int getRandomItem(RandomSource random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.m_188503_(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public static <T> int getRandomItem(List<? extends Map.Entry<Integer, T>> randomList, int size) {
        return GTUtil.getRandomItem(GTValues.RNG, randomList, size);
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static boolean isShiftDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)340) || InputConstants.m_84830_((long)id, (int)340);
        }
        return false;
    }

    public static boolean isCtrlDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)341) || InputConstants.m_84830_((long)id, (int)345);
        }
        return false;
    }

    public static boolean isAltDown() {
        if (LDLib.isClient()) {
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)342) || InputConstants.m_84830_((long)id, (int)346);
        }
        return false;
    }

    public static boolean isFluidStackAmountDivisible(FluidStack fluidStack, int divisor) {
        return fluidStack.getAmount() % (long)divisor == 0L && fluidStack.getAmount() % (long)divisor != fluidStack.getAmount() && fluidStack.getAmount() / (long)divisor != 0L;
    }

    public static boolean isItemStackCountDivisible(ItemStack itemStack, int divisor) {
        return itemStack.m_41613_() % divisor == 0 && itemStack.m_41613_() % divisor != itemStack.m_41613_() && itemStack.m_41613_() / divisor != 0;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getItemBurnTime(Item item) {
        return GTUtilImpl.getItemBurnTime(item);
    }

    public static DyeColor determineDyeColor(int rgbColor) {
        float[] c = GradientUtil.getRGB(rgbColor);
        HashMap<Double, DyeColor> distances = new HashMap<Double, DyeColor>();
        for (DyeColor dyeColor : DyeColor.values()) {
            float[] c2 = GradientUtil.getRGB(dyeColor.m_41071_());
            double distance = (c[0] - c2[0]) * (c[0] - c2[0]) + (c[1] - c2[1]) * (c[1] - c2[1]) + (c[2] - c2[2]) * (c[2] - c2[2]);
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (DyeColor)distances.get(min);
    }

    public static int convertRGBtoARGB(int colorValue) {
        return GTUtil.convertRGBtoARGB(colorValue, 255);
    }

    public static int convertRGBtoARGB(int colorValue, int opacity) {
        if ((colorValue >> 24 & 0xFF) != 0) {
            return colorValue;
        }
        return opacity << 24 | colorValue;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static long getPumpBiomeModifier(Holder<Biome> biome) {
        return GTUtilImpl.getPumpBiomeModifier(biome);
    }

    @Nullable
    public static Fluid getMoltenFluid(@Nonnull Material material) {
        if (material.hasProperty(PropertyKey.ALLOY_BLAST)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.MOLTEN);
        }
        if (!TagPrefix.ingotHot.doGenerateItem(material) && material.hasProperty(PropertyKey.FLUID)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.LIQUID);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidFromContainer(Object ingredient) {
        ItemStack itemStack;
        IFluidTransfer fluidHandler;
        if (ingredient instanceof FluidStack) {
            return (FluidStack)ingredient;
        }
        if (ingredient instanceof ItemStack && (fluidHandler = FluidTransferHelper.getFluidTransfer((ItemStack)(itemStack = (ItemStack)ingredient))) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    public static boolean canSeeSunClearly(Level world, BlockPos blockPos) {
        if (!world.m_45527_(blockPos.m_7494_())) {
            return false;
        }
        Biome biome = (Biome)world.m_204166_(blockPos.m_7494_()).m_203334_();
        if (world.m_46471_() && (biome.m_198906_(blockPos.m_7494_()) || biome.m_198904_(blockPos.m_7494_()))) {
            return false;
        }
        if (world.m_204166_(blockPos.m_7494_()).m_203656_(BiomeTags.f_215818_)) {
            return false;
        }
        return world.m_46461_();
    }
}

